/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.io.IOException;
import java.util.UUID;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.treeview.TreeView;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.Uuids;

public class TreeCommand
extends SingleCommand {
    public TreeCommand() {
        super(CommandSpec.TREE, "Tree", CommandPermission.TREE, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        String id;
        TreeView view;
        User user;
        String selection = ".";
        String player = null;
        if (!args.isEmpty()) {
            selection = args.get(0);
        }
        if (args.size() > 1) {
            player = args.get(1);
        }
        if (player != null) {
            UUID u = Uuids.parse(player);
            user = u != null ? (User)plugin.getUserManager().getIfLoaded(u) : plugin.getUserManager().getByUsername(player);
            if (user == null) {
                Message.USER_NOT_ONLINE.send(sender, player);
                return CommandResult.STATE_ERROR;
            }
        } else {
            user = null;
        }
        if (!(view = new TreeView(plugin.getPermissionRegistry(), selection)).hasData()) {
            Message.TREE_EMPTY.send(sender);
            return CommandResult.FAILURE;
        }
        Message.TREE_UPLOAD_START.send(sender);
        PermissionCache permissionData = user == null ? null : user.getCachedData().getPermissionData(user.getQueryOptions());
        try {
            id = view.uploadPasteData(plugin.getBytebin(), sender, user, permissionData);
        }
        catch (UnsuccessfulRequestException e) {
            Message.GENERIC_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
            return CommandResult.STATE_ERROR;
        }
        catch (IOException e) {
            plugin.getLogger().warn("Error uploading data to bytebin", e);
            Message.GENERIC_HTTP_UNKNOWN_FAILURE.send(sender);
            return CommandResult.STATE_ERROR;
        }
        String url = plugin.getConfiguration().get(ConfigKeys.TREE_VIEWER_URL_PATTERN) + id;
        Message.TREE_URL.send(sender, url);
        return CommandResult.SUCCESS;
    }
}

