/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Paginated<T> {
    private final List<T> content;

    public Paginated(Collection<T> content) {
        this.content = ImmutableList.copyOf(content);
    }

    public List<T> getContent() {
        return this.content;
    }

    public int getMaxPages(int entriesPerPage) {
        return (int)Math.ceil((double)this.content.size() / (double)entriesPerPage);
    }

    public List<Entry<T>> getPage(int pageNo, int pageSize) {
        if (pageNo < 1) {
            throw new IllegalArgumentException("pageNo cannot be less than 1: " + pageNo);
        }
        int first = (pageNo - 1) * pageSize;
        if (this.content.size() <= first) {
            throw new IllegalStateException("Content does not contain that many elements. (requested page: " + pageNo + ", page size: " + pageSize + ", page first index: " + first + ", content size: " + this.content.size() + ")");
        }
        int last = first + pageSize - 1;
        ArrayList<Entry<T>> out = new ArrayList<Entry<T>>(pageSize);
        for (int i = first; i <= last && i < this.content.size(); ++i) {
            out.add(new Entry<T>(i + 1, this.content.get(i)));
        }
        return out;
    }

    public static final class Entry<T> {
        private final int position;
        private final T value;

        public Entry(int position, T value) {
            this.position = position;
            this.value = value;
        }

        public int position() {
            return this.position;
        }

        public T value() {
            return this.value;
        }

        public String toString() {
            return this.position + ": " + this.value;
        }
    }
}

