/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.Collection;
import java.util.Map;
import me.lucko.luckperms.common.command.utils.ArgumentException;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.util.Tristate;

public final class SpongeCommandUtils {
    private SpongeCommandUtils() {
    }

    public static void sendPrefixed(Sender sender, String message) {
        sender.sendMessage((Component)Message.prefixed((ComponentLike)LegacyComponentSerializer.legacyAmpersand().deserialize(message)));
    }

    public static Tristate parseTristate(int index, ArgumentList args) throws ArgumentException {
        String s;
        switch (s = args.get(index).toLowerCase()) {
            case "1": 
            case "true": 
            case "t": {
                return Tristate.TRUE;
            }
            case "0": 
            case "null": 
            case "none": 
            case "undefined": 
            case "undef": {
                return Tristate.UNDEFINED;
            }
            case "-1": 
            case "false": 
            case "f": {
                return Tristate.FALSE;
            }
        }
        throw new ArgumentException.DetailedUsage();
    }

    public static String nodesToString(Map<String, Boolean> nodes) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Boolean> e : nodes.entrySet()) {
            sb.append("&3> ").append(e.getValue() != false ? "&a" : "&c").append(e.getKey()).append("\n");
        }
        return sb.toString();
    }

    public static String optionsToString(Map<String, String> options) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : options.entrySet()) {
            sb.append("&3> &a").append(e.getKey()).append(" &f= \"").append(e.getKey()).append("&f\"\n");
        }
        return sb.toString();
    }

    public static String parentsToString(Iterable<LPSubjectReference> parents) {
        StringBuilder sb = new StringBuilder();
        for (LPSubjectReference s : parents) {
            sb.append("&3> &a").append(s.getSubjectIdentifier()).append(" &bfrom collection &a").append(s.getCollectionIdentifier()).append("&b.\n");
        }
        return sb.toString();
    }

    public static String toCommaSep(Collection<String> strings) {
        return LegacyComponentSerializer.legacyAmpersand().serialize(Message.formatStringList(strings));
    }

    public static String contextToString(ContextSet set) {
        return LegacyComponentSerializer.legacyAmpersand().serialize(Message.formatContextSet(set));
    }
}

