/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.UniverseGuard;
import com.universeguard.event.flags.FlagItemUseTaskListener;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.InventoryUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagItemUseListener {
    @Listener
    public void onItemUse(InteractItemEvent event, @Root Player player) {
        Region region = RegionUtils.getRegion((Location<World>)player.getLocation());
        if (region != null) {
            ItemStackSnapshot item = event.getItemStack();
            if (!PermissionUtils.hasPermission(player, RegionPermission.REGION) && region.getDisallowedItems().contains(item.getType().getId())) {
                event.setCancelled(true);
                MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                ItemStack itemStack = item.createStack();
                InventoryUtils.removeFromInventory(player, itemStack);
                Task.builder().execute((Consumer)new FlagItemUseTaskListener(player, itemStack)).delay(0L, TimeUnit.MICROSECONDS).interval(0L, TimeUnit.MICROSECONDS).name("Item Use Flag Task").submit((Object)UniverseGuard.INSTANCE);
            }
        }
    }
}

