/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import com.flowpowered.math.vector.Vector3d;
import com.universeguard.UniverseGuard;
import java.util.Arrays;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.enchantment.EnchantmentTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.entity.MainPlayerInventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class InventoryUtils {
    public static ItemStack getSelector() {
        ItemStack selector = InventoryUtils.getItemStack(UniverseGuard.SELECTOR_ITEM);
        selector.offer(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextColors.LIGHT_PURPLE, "Region Selector"}));
        selector.offer(Keys.ITEM_ENCHANTMENTS, Arrays.asList(Enchantment.of((EnchantmentType)EnchantmentTypes.INFINITY, (int)1)));
        selector.offer(Keys.UNBREAKABLE, (Object)true);
        selector.offer(Keys.HIDE_ENCHANTMENTS, (Object)true);
        return selector.createSnapshot().createStack();
    }

    public static boolean isSelector(ItemStack itemStack) {
        ItemStack selector = InventoryUtils.getSelector();
        if (itemStack.get(Keys.DISPLAY_NAME).isPresent()) {
            Text selectorText;
            Text text = (Text)itemStack.get(Keys.DISPLAY_NAME).get();
            return text.equals((Object)(selectorText = (Text)selector.get(Keys.DISPLAY_NAME).get())) && selector.getType().equals(itemStack.getType());
        }
        return false;
    }

    public static boolean addItemStackToInventory(Player player, ItemStack itemStack) {
        boolean result = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(MainPlayerInventory.class)}).offer(itemStack).getType().equals((Object)InventoryTransactionResult.Type.SUCCESS);
        if (result) {
            return false;
        }
        InventoryUtils.dropItem(player.getWorld(), player.getPosition().add(0.0f, 0.25f, 0.0f), itemStack);
        return true;
    }

    public static void dropItem(World world, Vector3d location, ItemStack itemStack) {
        Entity itemStackEntity = world.createEntity(EntityTypes.ITEM, location);
        itemStackEntity.offer(Keys.REPRESENTED_ITEM, (Object)itemStack.createSnapshot());
        world.spawnEntity(itemStackEntity);
    }

    public static boolean addItemsToInventory(Player player, ItemType itemType, int quantity) {
        return InventoryUtils.addItemStackToInventory(player, ItemStack.of((ItemType)itemType, (int)quantity));
    }

    public static boolean addItemStackToHotbar(Player player, ItemStack itemStack) {
        Inventory inventory = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)});
        if (inventory instanceof Hotbar) {
            Hotbar hotbar = (Hotbar)inventory;
            Optional selectedSlot = hotbar.getSlot(new SlotIndex(hotbar.getSelectedSlotIndex()));
            if (selectedSlot.isPresent()) {
                if (((Slot)selectedSlot.get()).peek().isPresent()) {
                    ItemStack selectedStack = (ItemStack)((Slot)selectedSlot.get()).peek().get();
                    if (InventoryUtils.isSelector(selectedStack) && InventoryUtils.isSelector(itemStack)) {
                        return true;
                    }
                    for (int i = 0; i < hotbar.size() && i != hotbar.getSelectedSlotIndex(); ++i) {
                        Optional slot = hotbar.getSlot(new SlotIndex(i));
                        if (!slot.isPresent() || ((Slot)slot.get()).peek().isPresent()) continue;
                        hotbar.set(new SlotIndex(i), itemStack);
                        return true;
                    }
                } else {
                    hotbar.set(new SlotIndex(hotbar.getSelectedSlotIndex()), itemStack);
                    return true;
                }
            }
            return InventoryUtils.addItemStackToInventory(player, itemStack);
        }
        return false;
    }

    public static boolean removeFromInventory(Player player, ItemStack itemStack) {
        Inventory items = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of((Object)itemStack.getType())});
        if (items.peek(itemStack.getQuantity()).isPresent()) {
            items.poll(itemStack.getQuantity());
            return true;
        }
        return false;
    }

    public static ItemStack getItemStack(ItemType item) {
        return ItemStack.builder().itemType(item).quantity(1).build();
    }
}

