/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.module.kit.data;

import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.module.kit.KitRedeemResult;
import io.github.nucleuspowered.nucleus.api.module.kit.NucleusKitService;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public interface Kit {
    public String getName();

    public List<ItemStackSnapshot> getStacks();

    public Kit setStacks(List<ItemStackSnapshot> var1);

    @Deprecated
    default public Duration getInterval() {
        return this.getCooldown().orElse(Duration.ZERO);
    }

    public Optional<Duration> getCooldown();

    @Deprecated
    default public Kit setInterval(Duration interval) {
        return this.setCooldown(interval);
    }

    public Kit setCooldown(Duration var1);

    public double getCost();

    public Kit setCost(double var1);

    public boolean isAutoRedeem();

    public Kit setAutoRedeem(boolean var1);

    public boolean isOneTime();

    public Kit setOneTime(boolean var1);

    public List<String> getCommands();

    public Kit setCommands(List<String> var1);

    default public Kit addCommand(String command) {
        List<String> commands = this.getCommands();
        commands.add(command);
        return this.setCommands(commands);
    }

    public Kit updateKitInventory(Inventory var1);

    public Kit updateKitInventory(Player var1);

    default public Collection<ItemStack> getItemsForPlayer(Player player) {
        return NucleusAPI.getKitService().orElseThrow(() -> new IllegalStateException("No Kit module")).getItemsForPlayer(this, player);
    }

    default public KitRedeemResult redeem(Player player) {
        this.save();
        NucleusKitService kitService = NucleusAPI.getKitService().orElseThrow(() -> new IllegalStateException("No Kit module"));
        return kitService.redeemKit(this, player, true);
    }

    public void redeemKitCommands(Player var1);

    public boolean isDisplayMessageOnRedeem();

    public Kit setDisplayMessageOnRedeem(boolean var1);

    public boolean ignoresPermission();

    public Kit setIgnoresPermission(boolean var1);

    public boolean isHiddenFromList();

    public Kit setHiddenFromList(boolean var1);

    public boolean isFirstJoinKit();

    public Kit setFirstJoinKit(boolean var1);

    default public void save() {
        NucleusAPI.getKitService().orElseThrow(() -> new IllegalStateException("No Kit module")).saveKit(this);
    }
}

