/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.module.warp;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.api.module.warp.data.WarpCategory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
public interface NucleusWarpService {
    public Optional<Warp> getWarp(String var1);

    public boolean removeWarp(String var1);

    public boolean setWarp(String var1, Location<World> var2, Vector3d var3);

    public List<Warp> getAllWarps();

    public List<Warp> getUncategorisedWarps();

    public List<Warp> getWarpsForCategory(String var1);

    default public Map<WarpCategory, List<Warp>> getWarpsWithCategories() {
        return this.getWarpsWithCategories(x -> true);
    }

    public Map<WarpCategory, List<Warp>> getWarpsWithCategories(Predicate<Warp> var1);

    public boolean removeWarpCost(String var1);

    public boolean setWarpCost(String var1, double var2);

    public boolean setWarpCategory(String var1, @Nullable String var2);

    public boolean setWarpDescription(String var1, @Nullable Text var2);

    public Set<String> getWarpNames();

    default public boolean warpExists(String name) {
        return this.getWarp(name).isPresent();
    }

    public Optional<WarpCategory> getWarpCategory(String var1);

    public boolean setWarpCategoryDisplayName(String var1, @Nullable Text var2);

    public boolean setWarpCategoryDescription(String var1, @Nullable Text var2);
}

