/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.commands;

import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"afk", "away"}, basePermission={"nucleus.afk.base"}, commandDescriptionKey="afk")
@EssentialsEquivalent(value={"afk", "away"})
@NonnullByDefault
public class AFKCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        IPermissionService permissionService = context.getServiceCollection().permissionService();
        if (!permissionService.isOpOnly() && context.testPermission("nucleus.afk.exempt.toggle")) {
            return context.errorResult("command.afk.exempt", new Object[0]);
        }
        Player src = context.getIfPlayer();
        AFKHandler afkHandler = context.getServiceCollection().getServiceUnchecked(AFKHandler.class);
        boolean isAFK = afkHandler.isAFK(src);
        if (isAFK) {
            afkHandler.stageUserActivityUpdate(src);
        } else if (!afkHandler.setAfkInternal(src, context.getCause(), true)) {
            return context.errorResult("command.afk.notset", new Object[0]);
        }
        return context.successResult();
    }
}

