/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ban.commands;

import io.github.nucleuspowered.nucleus.modules.ban.config.BanConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanTypes;

@Command(aliases={"tempban"}, basePermission={"nucleus.tempban.base"}, commandDescriptionKey="tempban", associatedPermissions={"nucleus.tempban.exempt.length", "nucleus.tempban.exempt.target", "nucleus.tempban.offline"}, associatedPermissionLevelKeys={"nucleus.ban.level"})
@EssentialsEquivalent(value={"tempban"})
@NonnullByDefault
public class TempBanCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private BanConfig banConfig = new BanConfig();

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.banConfig = serviceCollection.moduleDataProvider().getModuleConfig(BanConfig.class);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), NucleusParameters.DURATION.get(serviceCollection), NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User u = context.requireOne("user", User.class);
        long time = context.requireOne("duration", Long.TYPE);
        String reason = context.getOne("reason", String.class).orElseGet(() -> context.getServiceCollection().messageProvider().getMessageString((CommandSource)context.getCommandSourceUnchecked(), "ban.defaultreason", new String[0]));
        if (!context.isConsoleAndBypass() && context.testPermissionFor((Subject)u, "nucleus.tempban.exempt.target")) {
            return context.errorResult("command.tempban.exempt", u.getName());
        }
        if (!u.isOnline() && !context.testPermission("nucleus.tempban.offline")) {
            return context.errorResult("command.tempban.offline.noperms", new Object[0]);
        }
        if (time > this.banConfig.getMaximumTempBanLength() && this.banConfig.getMaximumTempBanLength() != -1L && !context.testPermission("nucleus.tempban.exempt.length")) {
            return context.errorResult("command.tempban.length.toolong", context.getTimeString(this.banConfig.getMaximumTempBanLength()));
        }
        BanService service = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        if (service.isBanned(u.getProfile())) {
            return context.errorResult("command.ban.alreadyset", u.getName());
        }
        if (this.banConfig.getLevelConfig().isUseLevels() && !context.isPermissionLevelOkay((Subject)u, "nucleus.ban.level", "nucleus.tempban.base", this.banConfig.getLevelConfig().isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", u.getName());
        }
        Instant date = Instant.now().plus(time, ChronoUnit.SECONDS);
        CommandSource src = context.getCommandSource();
        Ban bp = Ban.builder().type(BanTypes.PROFILE).profile(u.getProfile()).source(src).expirationDate(date).reason(TextSerializers.FORMATTING_CODE.deserialize(reason)).build();
        service.addBan(bp);
        MutableMessageChannel send = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.ban.notify").asMutable();
        send.addMember((MessageReceiver)src);
        for (MessageReceiver messageReceiver : send.getMembers()) {
            if (!(messageReceiver instanceof CommandSource)) continue;
            context.sendMessageTo(messageReceiver, "command.tempban.applied", u.getName(), context.getTimeString(time), src.getName());
            context.sendMessageTo(messageReceiver, "standard.reasoncoloured", reason);
        }
        if (Sponge.getServer().getPlayer(u.getUniqueId()).isPresent()) {
            ((Player)Sponge.getServer().getPlayer(u.getUniqueId()).get()).kick(TextSerializers.FORMATTING_CODE.deserialize(reason));
        }
        return context.successResult();
    }
}

