/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.environment.commands;

import io.github.nucleuspowered.nucleus.modules.environment.EnvironmentKeys;
import io.github.nucleuspowered.nucleus.modules.environment.config.EnvironmentConfig;
import io.github.nucleuspowered.nucleus.modules.environment.parameter.WeatherArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.weather.Weather;

@NonnullByDefault
@EssentialsEquivalent(value={"thunder", "sun", "weather", "sky", "storm", "rain"})
@Command(aliases={"weather"}, basePermission={"nucleus.weather.base"}, commandDescriptionKey="weather", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.weather.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.weather.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.weather.exempt.cost")}, associatedPermissions={"nucleus.weather.exempt.length"})
public class WeatherCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String weather = "weather";
    private long max = Long.MAX_VALUE;

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.max = serviceCollection.moduleDataProvider().getModuleConfig(EnvironmentConfig.class).getMaximumWeatherTimespan();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_WEAK_WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection), GenericArguments.onlyOne((CommandElement)new WeatherArgument((Text)Text.of((String)this.weather), serviceCollection)), NucleusParameters.OPTIONAL_DURATION.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties wp = context.getWorldPropertiesOrFromSelf("world").orElseGet(() -> (WorldProperties)Sponge.getServer().getDefaultWorld().get());
        World w = (World)Sponge.getServer().getWorld(wp.getUniqueId()).orElseThrow(() -> context.createException("args.worldproperties.notloaded", wp.getWorldName()));
        if (context.getServiceCollection().storageManager().getWorldOnThread(w.getUniqueId()).map(x -> x.get(EnvironmentKeys.LOCKED_WEATHER).orElse(false)).orElse(false).booleanValue()) {
            return context.errorResult("command.weather.locked", w.getName());
        }
        Weather we = context.requireOne(this.weather, Weather.class);
        Optional<Long> oi = context.getOne("duration", Long.class);
        if (this.max > 0L && oi.orElse(Long.MAX_VALUE) > this.max && !context.testPermission("nucleus.weather.exempt.length")) {
            return context.errorResult("command.weather.toolong", context.getTimeString(this.max));
        }
        if (oi.isPresent()) {
            Task.builder().execute(() -> w.setWeather(we, (Long)oi.get() * 20L)).submit((Object)context.getServiceCollection().pluginContainer());
            context.sendMessage("command.weather.time", we.getName(), w.getName(), context.getTimeString(oi.get()));
        } else {
            Task.builder().execute(() -> w.setWeather(we)).submit((Object)context.getServiceCollection().pluginContainer());
            context.sendMessage("command.weather.set", we.getName(), w.getName());
        }
        return context.successResult();
    }
}

