/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fly.listeners;

import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.fly.FlyKeys;
import io.github.nucleuspowered.nucleus.modules.fly.config.FlyConfig;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.World;

public class FlyListener
implements IReloadableService.Reloadable,
ListenerBase {
    private final INucleusServiceCollection serviceCollection;
    private FlyConfig flyConfig;

    public FlyListener(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.flyConfig = serviceCollection.moduleDataProvider().getDefaultModuleConfig(FlyConfig.class);
    }

    @Listener(order=Order.FIRST)
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player pl) {
        if (FlyListener.shouldIgnoreFromGameMode(pl)) {
            return;
        }
        if (this.flyConfig.isPermissionOnLogin() && !this.serviceCollection.permissionService().hasPermission((Subject)pl, "nucleus.fly.base")) {
            this.safeTeleport(pl);
            return;
        }
        this.serviceCollection.storageManager().getUser(pl.getUniqueId()).thenAccept(x -> x.ifPresent(y -> {
            if (y.get(FlyKeys.FLY_TOGGLE).orElse(false).booleanValue()) {
                if (Sponge.getServer().isMainThread()) {
                    this.exec(pl);
                } else {
                    Task.builder().execute(() -> this.exec(pl)).submit((Object)this.serviceCollection.pluginContainer());
                }
            } else if (Sponge.getServer().isMainThread()) {
                this.safeTeleport(pl);
            } else {
                Task.builder().execute(() -> this.safeTeleport(pl)).submit((Object)this.serviceCollection.pluginContainer());
            }
        }));
    }

    private void exec(Player pl) {
        pl.offer(Keys.CAN_FLY, (Object)true);
        if (pl.getLocation().add(0.0, -1.0, 0.0).getBlockType().getId().equals(BlockTypes.AIR.getId())) {
            pl.offer(Keys.IS_FLYING, (Object)true);
        }
    }

    @Listener
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player pl) {
        if (!this.flyConfig.isSaveOnQuit()) {
            return;
        }
        if (FlyListener.shouldIgnoreFromGameMode(pl)) {
            return;
        }
        this.serviceCollection.storageManager().getOrCreateUser(pl.getUniqueId()).thenAccept(x -> x.set(FlyKeys.FLY_TOGGLE, pl.get(Keys.CAN_FLY).orElse(false)));
    }

    @Listener(order=Order.LAST)
    public void onPlayerTransferWorld(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Entity target, @Getter(value="getFromTransform") Transform<World> twfrom, @Getter(value="getToTransform") Transform<World> twto) {
        if (!(target instanceof Player)) {
            return;
        }
        Player pl = (Player)target;
        if (FlyListener.shouldIgnoreFromGameMode(pl)) {
            return;
        }
        boolean isFlying = target.get(Keys.IS_FLYING).orElse(false);
        if (!((World)twfrom.getExtent()).getUniqueId().equals(((World)twto.getExtent()).getUniqueId())) {
            Sponge.getScheduler().createTaskBuilder().execute(() -> {
                if (this.serviceCollection.permissionService().hasPermission((Subject)pl, "nucleus.fly.base")) {
                    target.offer(Keys.CAN_FLY, (Object)true);
                    if (isFlying) {
                        target.offer(Keys.IS_FLYING, (Object)true);
                    }
                } else {
                    this.serviceCollection.storageManager().getOrCreateUser(pl.getUniqueId()).thenAccept(x -> x.set(FlyKeys.FLY_TOGGLE, false));
                    target.offer(Keys.CAN_FLY, (Object)false);
                    target.offer(Keys.IS_FLYING, (Object)false);
                }
            }).submit((Object)this.serviceCollection.pluginContainer());
        }
    }

    static boolean shouldIgnoreFromGameMode(Player player) {
        GameMode gm = player.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET);
        return gm.equals(GameModes.CREATIVE) || gm.equals(GameModes.SPECTATOR);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.flyConfig = this.serviceCollection.moduleDataProvider().getModuleConfig(FlyConfig.class);
    }

    private void safeTeleport(Player pl) {
        if (!pl.isOnGround() && this.flyConfig.isFindSafeOnLogin()) {
            this.serviceCollection.teleportService().teleportPlayerSmart(pl, (Transform<World>)pl.getTransform(), false, true, TeleportScanners.DESCENDING_SCAN.get());
        }
    }
}

