/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.freezeplayer.services;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.github.nucleuspowered.nucleus.api.module.freezeplayer.NucleusFreezePlayerService;
import io.github.nucleuspowered.nucleus.modules.freezeplayer.FreezePlayerKeys;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;

@APIService(value=NucleusFreezePlayerService.class)
public class FreezePlayerService
implements ServiceBase,
NucleusFreezePlayerService {
    private final INucleusServiceCollection serviceCollection;
    private final LoadingCache<UUID, Boolean> cache;

    @Inject
    public FreezePlayerService(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.cache = Caffeine.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build(uuid -> this.serviceCollection.storageManager().getUserService().getOnThread((UUID)uuid).flatMap(x -> x.get(FreezePlayerKeys.FREEZE_PLAYER)).orElse(false));
    }

    public boolean getFromUUID(@Nonnull UUID uuid) {
        Boolean b = (Boolean)this.cache.get((Object)uuid);
        return b != null ? b : false;
    }

    public void invalidate(@Nonnull UUID uuid) {
        this.cache.invalidate((Object)uuid);
    }

    @Override
    public boolean isFrozen(UUID uuid) {
        return this.getFromUUID(uuid);
    }

    @Override
    public void setFrozen(UUID uuid, boolean freeze) {
        this.serviceCollection.storageManager().getUserService().setAndSave(uuid, FreezePlayerKeys.FREEZE_PLAYER, freeze);
        this.cache.put((Object)uuid, (Object)freeze);
    }
}

