/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.commands;

import io.github.nucleuspowered.nucleus.modules.invulnerability.services.InvulnerabilityService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"god", "godmode", "tgm"})
@Command(aliases={"god", "invuln", "invulnerability"}, basePermission={"nucleus.god.base"}, commandDescriptionKey="god", associatedPermissions={"nucleus.god.others", "nucleus.god.pvp.override"})
public class InvulnerabilityCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.god.others"), NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        InvulnerabilityService service = context.getServiceCollection().getServiceUnchecked(InvulnerabilityService.class);
        boolean god = context.getOne("true|false", Boolean.class).orElse(!service.isInvulnerable((User)pl));
        try {
            service.setInvulnerable((User)pl, god);
        }
        catch (Exception e) {
            e.printStackTrace();
            return context.failResult();
        }
        if (!context.is(pl)) {
            context.sendMessage(god ? "command.god.player.on" : "command.god.player.off", pl.getName());
        }
        context.sendMessageTo((MessageReceiver)pl, god ? "command.god.on" : "command.god.off", new Object[0]);
        return context.successResult();
    }
}

