/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.BoundedIntegerArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.ImprovedCatalogTypeArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"enchant", "enchantment"})
@Command(aliases={"enchant", "enchantment"}, basePermission={"nucleus.enchant.base"}, commandDescriptionKey="enchant", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.enchant.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.enchant.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.enchant.exempt.cost")}, associatedPermissions={"nucleus.enchant.unsafe"})
public class EnchantCommand
implements ICommandExecutor<Player> {
    private final String enchantmentKey = "enchantment";
    private final String levelKey = "level";
    private final String unsafeKey = "unsafe";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{new ImprovedCatalogTypeArgument((Text)Text.of((String)this.enchantmentKey), EnchantmentType.class, serviceCollection), new BoundedIntegerArgument((Text)Text.of((String)this.levelKey), 0, Short.MAX_VALUE, serviceCollection), GenericArguments.flags().valueFlag((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(GenericArguments.markTrue((Text)Text.of((String)this.unsafeKey)), "nucleus.enchant.unsafe", false), new String[]{"u", "-unsafe"}).flag(new String[]{"o", "-overwrite"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return context.errorResult("command.enchant.noitem", new Object[0]);
        }
        ItemStack itemInHand = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        EnchantmentType enchantment = context.requireOne(this.enchantmentKey, EnchantmentType.class);
        int level = context.requireOne(this.levelKey, Integer.class);
        boolean allowUnsafe = context.hasAny(this.unsafeKey);
        boolean allowOverwrite = context.hasAny("o");
        if (!allowUnsafe) {
            if (!enchantment.canBeAppliedToStack(itemInHand)) {
                return context.errorResult("command.enchant.nounsafe.enchant", itemInHand);
            }
            if (level > enchantment.getMaximumLevel()) {
                return context.errorResult("command.enchant.nounsafe.level", itemInHand);
            }
        }
        EnchantmentData ed = (EnchantmentData)itemInHand.getOrCreate(EnchantmentData.class).get();
        List currentEnchants = (List)ed.getListValue().get();
        if (level == 0) {
            if (!currentEnchants.removeIf(x -> x.getType().getId().equals(enchantment.getId()))) {
                return context.errorResult("command.enchant.noenchantment", enchantment);
            }
        } else {
            List<Enchantment> enchantmentsToRemove = currentEnchants.stream().filter(x -> !x.getType().isCompatibleWith(enchantment) || x.getType().equals(enchantment)).collect(Collectors.toList());
            if (!allowOverwrite && !enchantmentsToRemove.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                enchantmentsToRemove.forEach(x -> {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(Util.getTranslatableIfPresent(x.getType()));
                });
                return context.errorResult("command.enchant.overwrite", sb.toString());
            }
            currentEnchants.removeIf(enchantmentsToRemove::contains);
            currentEnchants.add(Enchantment.of((EnchantmentType)enchantment, (int)level));
        }
        ed.setElements(currentEnchants);
        DataTransactionResult dtr = itemInHand.offer((ValueContainer)ed);
        if (dtr.isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, itemInHand);
            if (level == 0) {
                context.sendMessage("command.enchant.removesuccess", enchantment);
            } else {
                context.sendMessage("command.enchant.success", enchantment, level);
            }
            return context.successResult();
        }
        return context.errorResult("command.enchant.error", enchantment, level);
    }
}

