/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"showitemattributes", "showattributes"}, basePermission={"nucleus.showitemattributes.base"}, commandDescriptionKey="showitemattributes", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.showitemattributes.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.showitemattributes.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.showitemattributes.exempt.cost")})
public class ShowAttributesCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        ItemStack itemStack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> context.createException("command.generalerror.handempty", new Object[0]));
        boolean b = context.getOne("true|false", Boolean.class).orElseGet(() -> itemStack.get(Keys.HIDE_ATTRIBUTES).orElse(false));
        itemStack.offer(Keys.HIDE_ATTRIBUTES, (Object)(!b ? 1 : 0));
        src.setItemInHand(HandTypes.MAIN_HAND, itemStack);
        context.sendMessage("command.showitemattributes.success." + b, Text.of((Translatable)itemStack, (Object[])new Object[0]));
        return context.successResult();
    }
}

