/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.lore;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
abstract class LoreModifyBaseCommand
implements ICommandExecutor<Player> {
    final String loreLine = "line";

    LoreModifyBaseCommand() {
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{new PositiveIntegerArgument((Text)Text.of((String)this.loreLine), false, serviceCollection), NucleusParameters.LORE};
    }

    ICommandResult setLore(ICommandContext<? extends Player> context, String message, int line, boolean editOrInsert) throws CommandException {
        Player src = context.getIfPlayer();
        --line;
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> context.createException("command.lore.set.noitem", new Object[0]));
        LoreData loreData = (LoreData)stack.getOrCreate(LoreData.class).get();
        Text getLore = TextSerializers.FORMATTING_CODE.deserialize(message);
        List loreList = (List)loreData.lore().get();
        if (editOrInsert) {
            if (loreList.size() < line) {
                return context.errorResult("command.lore.set.invalidEdit", new Object[0]);
            }
            loreList.set(line, getLore);
        } else if (loreList.size() < line) {
            loreList.add(getLore);
        } else {
            loreList.add(line, getLore);
        }
        if (stack.offer(Keys.ITEM_LORE, (Object)loreList).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            context.sendMessage("command.lore.set.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.lore.set.fail", new Object[0]);
    }
}

