/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.datatypes.LocationData;
import io.github.nucleuspowered.nucleus.modules.jail.JailParameters;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfig;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Command(aliases={"jail"}, basePermission={"nucleus.jail.base"}, commandDescriptionKey="jail", associatedPermissions={"nucleus.jail.notify", "nucleus.jail.offline", "nucleus.jail.exempt.target", "nucleus.jail.teleportjailed", "nucleus.jail.teleporttojailed"}, associatedPermissionLevelKeys={"nucleus.jail.level"})
@EssentialsEquivalent(value={"togglejail", "tjail", "jail"}, isExact=false, notes="This command is not a toggle.")
public class JailCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();
    private final JailHandler handler;

    @Inject
    public JailCommand(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(JailHandler.class);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection), JailParameters.OPTIONAL_JAIL.get(serviceCollection), NucleusParameters.OPTIONAL_WEAK_DURATION.get(serviceCollection), NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User pl = context.requireOne("user", User.class);
        if (!pl.isOnline() && !context.testPermission("nucleus.jail.offline")) {
            return context.errorResult("command.jail.offline.noperms", new Object[0]);
        }
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)pl, "nucleus.jail.level", "nucleus.jail.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", pl.getName());
        }
        if (this.handler.isPlayerJailed(pl)) {
            return context.errorResult("command.jail.alreadyjailed", pl.getName());
        }
        if (!context.isConsoleAndBypass() && context.testPermissionFor((Subject)pl, "nucleus.jail.exempt.target")) {
            return context.errorResult("command.jail.exempt", pl.getName());
        }
        return this.onJail(context, pl);
    }

    private ICommandResult onJail(ICommandContext<? extends CommandSource> context, User user) throws CommandException {
        Text messageTo;
        Text message;
        JailData jd;
        Optional<LocationData> owl = context.getOne("jail", LocationData.class);
        if (!owl.isPresent()) {
            return context.errorResult("command.jail.jail.nojail", new Object[0]);
        }
        Optional<Long> duration = context.getOne("duration", Long.class);
        String reason = context.getOne("reason", String.class).orElseGet(() -> context.getMessageString("command.jail.reason", new Object[0]));
        CommandSource src = context.getCommandSource();
        if (duration.isPresent()) {
            jd = user.isOnline() ? new JailData(Util.getUUID(src), owl.get().getName(), reason, (Location<World>)((Player)user.getPlayer().get()).getLocation(), Instant.now().plusSeconds(duration.get())) : new JailData(Util.getUUID(src), owl.get().getName(), reason, null, Duration.of(duration.get(), ChronoUnit.SECONDS));
            IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
            message = context.getMessage("command.checkjail.jailedfor", user.getName(), jd.getJailName(), src.getName(), messageProviderService.getTimeString(src.getLocale(), duration.get()));
            messageTo = context.getMessage("command.jail.jailedfor", owl.get().getName(), src.getName(), messageProviderService.getTimeString(src.getLocale(), duration.get()));
        } else {
            jd = new JailData(Util.getUUID(src), owl.get().getName(), reason, (Location<World>)((Location)user.getPlayer().map(Locatable::getLocation).orElse(null)));
            message = context.getMessage("command.checkjail.jailedperm", user.getName(), owl.get().getName(), src.getName());
            messageTo = context.getMessage("command.jail.jailedperm", owl.get().getName(), src.getName());
        }
        if (this.handler.jailPlayer(user, jd)) {
            MutableMessageChannel mc = new PermissionMessageChannel(context.getServiceCollection().permissionService(), "nucleus.jail.notify").asMutable();
            mc.addMember((MessageReceiver)src);
            mc.send(message);
            mc.send(context.getMessage("standard.reasoncoloured", reason));
            user.getPlayer().ifPresent(x -> {
                x.sendMessage(messageTo);
                x.sendMessage(context.getMessage("standard.reasoncoloured", reason));
            });
            return context.successResult();
        }
        return context.errorResult("command.jail.error", new Object[0]);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        boolean requireUnjailPermission = serviceCollection.moduleDataProvider().getModuleConfig(JailConfig.class).isRequireUnjailPermission();
        this.levelConfig = serviceCollection.moduleDataProvider().getModuleConfig(JailConfig.class).getCommonPermissionLevelConfig();
    }
}

