/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

@NonnullByDefault
@Command(aliases={"unstuck"}, basePermission={"nucleus.unstuck.base"}, commandDescriptionKey="unstuck", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.unstuck.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.unstuck.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.unstuck.exempt.cost")})
public class UnstuckCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private int radius = 1;
    private int height = 1;

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        Location location = (Location)Sponge.getGame().getTeleportHelper().getSafeLocation(src.getLocation(), this.height, this.radius).orElseThrow(() -> context.createException("command.unstuck.nolocation", new Object[0]));
        if (location.getBlockPosition().equals((Object)src.getLocation().getBlockPosition())) {
            return context.errorResult("command.unstuck.notneeded", new Object[0]);
        }
        if (context.getServiceCollection().teleportService().teleportPlayer(src, (Location<World>)location, false, TeleportScanners.NO_SCAN.get(), TeleportHelperFilters.DEFAULT, new TeleportHelperFilter[0]).isSuccessful() && context.getServiceCollection().teleportService().setLocation(src, (Location<World>)location)) {
            context.sendMessage("command.unstuck.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.unstuck.cancelled", new Object[0]);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        JumpConfig c = serviceCollection.moduleDataProvider().getModuleConfig(JumpConfig.class);
        this.radius = c.getMaxUnstuckRadius();
        this.height = c.getMaxUnstuckHeight();
    }
}

