/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mail.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.mail.NucleusMailService;
import io.github.nucleuspowered.nucleus.api.module.mail.data.MailMessage;
import io.github.nucleuspowered.nucleus.modules.mail.MailKeys;
import io.github.nucleuspowered.nucleus.modules.mail.data.MailData;
import io.github.nucleuspowered.nucleus.modules.mail.events.InternalNucleusMailEvent;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;

@APIService(value=NucleusMailService.class)
public class MailHandler
implements NucleusMailService,
ServiceBase {
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public MailHandler(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    @Override
    public final List<MailMessage> getMail(User player, NucleusMailService.MailFilter ... filters) {
        return Lists.newArrayList(this.getMailInternal(player, filters));
    }

    public final List<MailMessage> getMailInternal(User player, NucleusMailService.MailFilter ... filters) {
        List data = (List)((Object)((IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(player.getUniqueId())).getNullable(MailKeys.MAIL_DATA));
        if (data == null || data.isEmpty()) {
            return ImmutableList.of();
        }
        if (filters.length == 0) {
            return ImmutableList.copyOf((Collection)data);
        }
        Predicate<MailMessage> lmf = Arrays.stream(filters).map(x -> x).reduce(Predicate::and).orElse(x -> true);
        return (List)data.stream().filter(lmf).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean removeMail(User player, MailMessage mailData) {
        IUserDataObject dataObject = (IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(player.getUniqueId());
        List data = dataObject.get(MailKeys.MAIL_DATA).orElseGet(ArrayList::new);
        boolean result = data.removeIf(x -> mailData.getDate().equals(x.getDate()) && mailData.getMessage().equalsIgnoreCase(x.getMessage()) && Objects.equals(mailData.getSender().orElse(null), x.getSender().orElse(null)));
        if (result) {
            dataObject.set(MailKeys.MAIL_DATA, data);
            this.serviceCollection.storageManager().getUserService().save(player.getUniqueId(), dataObject);
        }
        return result;
    }

    @Override
    public void sendMail(@Nullable User playerFrom, User playerTo, String message) {
        IUserDataObject dataObject = (IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(playerTo.getUniqueId());
        IMessageProviderService messageProvider = this.serviceCollection.messageProvider();
        if (Sponge.getEventManager().post((Event)new InternalNucleusMailEvent(playerFrom, playerTo, message))) {
            if (playerFrom == null) {
                messageProvider.sendMessageTo((CommandSource)Sponge.getServer().getConsole(), "message.cancel");
            } else {
                playerFrom.getPlayer().ifPresent(x -> messageProvider.sendMessageTo((CommandSource)x, "message.cancel"));
            }
            return;
        }
        List messages = dataObject.get(MailKeys.MAIL_DATA).orElseGet(ArrayList::new);
        MailData md = new MailData(playerFrom == null ? Util.CONSOLE_FAKE_UUID : playerFrom.getUniqueId(), Instant.now(), message);
        messages.add(md);
        dataObject.set(MailKeys.MAIL_DATA, messages);
        this.serviceCollection.storageManager().getUserService().save(playerTo.getUniqueId(), dataObject);
        LiteralText from = playerFrom == null ? Text.of((String)Sponge.getServer().getConsole().getName()) : this.serviceCollection.playerDisplayNameService().getDisplayName(playerFrom);
        playerTo.getPlayer().ifPresent(arg_0 -> MailHandler.lambda$sendMail$4(messageProvider, (Text)from, arg_0));
    }

    @Override
    public void sendMailFromConsole(User playerTo, String message) {
        this.sendMail(null, playerTo, message);
    }

    @Override
    public boolean clearUserMail(User player) {
        IStorageManager storageManager = this.serviceCollection.storageManager();
        IUserDataObject dataObject = (IUserDataObject)storageManager.getUserService().getOrNewOnThread(player.getUniqueId());
        if (dataObject.getNullable(MailKeys.MAIL_DATA) != null) {
            dataObject.remove(MailKeys.MAIL_DATA);
            storageManager.getUserService().save(player.getUniqueId(), dataObject);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$sendMail$4(IMessageProviderService messageProvider, Text from, Player x) {
        x.sendMessage(Text.builder().append(new Text[]{messageProvider.getMessageFor((CommandSource)x, "mail.youvegotmail")}).append(new Text[]{Text.of((Object[])new Object[]{" ", from})}).build());
    }
}

