/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.serializer.TextSerializers;

public class HelpOpMessageChannel
implements IChatMessageFormatterService.Channel {
    private final IPermissionService permissionService;
    private final ITextStyleService textStyleService;
    private final @Nullable NucleusTextTemplate prefix;

    public HelpOpMessageChannel(@Nullable NucleusTextTemplate prefix, IPermissionService permissionService, ITextStyleService textStyleService) {
        this.permissionService = permissionService;
        this.textStyleService = textStyleService;
        this.prefix = prefix;
    }

    @Override
    public boolean willFormat() {
        return true;
    }

    @Override
    public void formatMessageEvent(CommandSource source, MessageEvent.MessageFormatter formatters) {
        if (this.prefix != null) {
            if (TextSerializers.PLAIN.serialize(formatters.getHeader().toText()).contains("<" + source.getName() + ">")) {
                Text p = formatters.getHeader().toText().replace("<" + source.getName() + ">", Text.of(), true);
                if (p.toPlain().trim().isEmpty()) {
                    formatters.setHeader((TextRepresentable)this.prefix.getForCommandSource(source));
                } else {
                    formatters.setHeader((TextRepresentable)Text.of((Object[])new Object[]{p, this.prefix.getForCommandSource(source)}));
                }
            } else {
                formatters.setHeader((TextRepresentable)Text.of((Object[])new Object[]{formatters.getHeader(), this.prefix.getForCommandSource(source)}));
            }
        }
        ITextStyleService.TextFormat format = this.textStyleService.getLastColourAndStyle((TextRepresentable)formatters.getHeader(), null);
        formatters.setBody((TextRepresentable)Text.builder().color(format.colour()).style(new TextStyle[]{format.style()}).append(new Text[]{formatters.getBody().format()}).build());
    }

    @Override
    public Collection<MessageReceiver> receivers() {
        ArrayList members = Lists.newArrayList((Object[])new MessageReceiver[]{Sponge.getServer().getConsole()});
        Sponge.getServer().getOnlinePlayers().stream().filter(x -> this.permissionService.hasPermission((Subject)x, "nucleus.helpop.receive")).forEach(members::add);
        return members;
    }
}

