/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"heal"})
@NonnullByDefault
@Command(aliases={"heal"}, basePermission={"nucleus.heal.base"}, commandDescriptionKey="heal", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.heal.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.heal.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.heal.exempt.cost")}, associatedPermissions={"nucleus.heal.others"})
public class HealCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.heal.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        if (pl.offer(Keys.HEALTH, pl.get(Keys.MAX_HEALTH).get()).isSuccessful()) {
            pl.offer(Keys.FIRE_TICKS, (Object)0);
            context.sendMessageTo((MessageReceiver)pl, "command.heal.success.self", new Object[0]);
            if (!context.is(pl)) {
                context.sendMessage("command.heal.success.other", pl.getName());
            }
            return context.successResult();
        }
        return context.errorResult("command.heal.error", new Object[0]);
    }
}

