/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.UUIDArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Instant;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(async=true, aliases={"checkmute"}, basePermission={"nucleus.checkmute.base"}, commandDescriptionKey="checkmute")
public class CheckMuteCommand
implements ICommandExecutor<CommandSource> {
    private final String playerKey = "user/UUID";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.user((Text)Text.of((String)this.playerKey)), new UUIDArgument((Text)Text.of((String)this.playerKey), u -> ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(u), serviceCollection)})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.requireOne(this.playerKey, User.class);
        MuteHandler muteHandler = context.getServiceCollection().getServiceUnchecked(MuteHandler.class);
        Optional<MuteData> omd = muteHandler.getPlayerMuteData(user);
        if (!omd.isPresent()) {
            context.sendMessage("command.checkmute.none", user.getName());
            return context.successResult();
        }
        MuteData md = omd.get();
        String name = !md.getMuter().isPresent() ? Sponge.getServer().getConsole().getName() : ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(md.getMuter().get()).map(User::getName).orElseGet(() -> context.getMessageString("standard.unknown", new Object[0]));
        if (md.getRemainingTime().isPresent()) {
            context.sendMessage("command.checkmute.mutedfor", user.getName(), name, context.getTimeString(md.getRemainingTime().get().getSeconds()));
        } else {
            context.sendMessage("command.checkmute.mutedperm", user.getName(), name);
        }
        if (md.getCreationTime() > 0L) {
            context.sendMessage("command.checkmute.created", Util.FULL_TIME_FORMATTER.withLocale(context.getCommandSource().getLocale()).format(Instant.ofEpochSecond(md.getCreationTime())));
        } else {
            context.sendMessage("command.checkmute.created", "loc:standard.unknown");
        }
        context.sendMessage("standard.reasoncoloured", md.getReason());
        return context.successResult();
    }
}

