/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.ArrayList;
import java.util.Map;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

@EssentialsEquivalent(value={"realname"})
@Command(aliases={"realname"}, basePermission={"nucleus.realname.base"}, commandDescriptionKey="realname")
public class RealnameCommand
implements ICommandExecutor<CommandSource> {
    private final String playerKey = "name";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.string((Text)Text.of((String)"name"))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String argname = context.requireOne(this.playerKey, String.class);
        NicknameService service = context.getServiceCollection().getServiceUnchecked(NicknameService.class);
        Map<Player, Text> names = service.getFromSubstring(argname.toLowerCase());
        names.forEach((player, text) -> {});
        if (names.isEmpty()) {
            context.sendMessage("command.realname.nonames", argname);
        } else {
            ArrayList<Text> realNames = new ArrayList<Text>();
            for (Map.Entry<Player, Text> entry : names.entrySet()) {
                realNames.add(Text.of((Object[])new Object[]{entry.getKey().getName(), TextColors.GRAY, " -> ", TextColors.WHITE, entry.getValue()}));
            }
            PaginationList.Builder plb = Util.getPaginationBuilder(context.getCommandSource()).contents(realNames).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(context.getMessage("command.realname.title", argname));
            plb.sendTo((MessageReceiver)context.getCommandSource());
        }
        return context.successResult();
    }
}

