/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.listeners;

import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;

public class NicknameListener
implements ListenerBase {
    private final NicknameService nicknameService;

    @Inject
    public NicknameListener(INucleusServiceCollection serviceCollection) {
        this.nicknameService = serviceCollection.getServiceUnchecked(NicknameService.class);
    }

    @Listener(order=Order.FIRST)
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Root Player player) {
        Optional<Text> nickname = this.nicknameService.getNickname((User)player);
        this.nicknameService.markRead(player.getUniqueId());
        nickname.ifPresent(text -> this.nicknameService.updateCache(player.getUniqueId(), (Text)text));
        player.offer(Keys.DISPLAY_NAME, (Object)nickname.orElseGet(() -> Text.of((String)player.getName())));
    }

    @Listener(order=Order.LAST)
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event, @Root Player player) {
        this.nicknameService.removeFromCache(player.getUniqueId());
    }
}

