/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.note.NucleusNoteService;
import io.github.nucleuspowered.nucleus.api.module.note.data.Note;
import io.github.nucleuspowered.nucleus.modules.note.NoteKeys;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.event.CreateNoteEvent;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.storage.dataobjects.IDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.IKeyedDataObject;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;

@APIService(value=NucleusNoteService.class)
public class NoteHandler
implements NucleusNoteService,
ServiceBase {
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public NoteHandler(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    public List<NoteData> getNotesInternal(User user) {
        Optional userDataObject = this.serviceCollection.storageManager().getUserService().getOnThread(user.getUniqueId());
        return userDataObject.flatMap(udo -> udo.get(NoteKeys.NOTE_DATA)).orElseGet(ImmutableList::of);
    }

    @Override
    public ImmutableList<Note> getNotes(User user) {
        return ImmutableList.copyOf(this.getNotesInternal(user));
    }

    @Override
    public boolean addNote(User user, CommandSource source, String note) {
        return this.addNote(user, new NoteData(Instant.now(), Util.getUUID(source), note));
    }

    public boolean addNote(User user, NoteData note) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)note);
        IUserDataObject udo = (IUserDataObject)this.serviceCollection.storageManager().getUserService().getOrNewOnThread(user.getUniqueId());
        try (IKeyedDataObject.Value<NoteData> v = udo.getAndSet(NoteKeys.NOTE_DATA);){
            List data = v.getValue().orElseGet(Lists::newArrayList);
            data.add(note);
            v.setValue((NoteData)((Object)data));
        }
        CreateNoteEvent event = new CreateNoteEvent(note.getNoterInternal(), note.getNote(), note.getDate(), user, Sponge.getCauseStackManager().getCurrentCause());
        Sponge.getEventManager().post((Event)event);
        this.serviceCollection.storageManager().getUserService().save(user.getUniqueId(), udo);
        return true;
    }

    @Override
    public boolean removeNote(User user, Note note) {
        Optional udo = this.serviceCollection.storageManager().getUserService().getOnThread(user.getUniqueId());
        if (udo.isPresent()) {
            boolean res;
            try (IKeyedDataObject.Value<NoteData> v = ((IUserDataObject)udo.get()).getAndSet(NoteKeys.NOTE_DATA);){
                List data = v.getValue().orElseGet(Lists::newArrayList);
                res = data.removeIf(x -> x.equals(note));
                v.setValue((NoteData)((Object)data));
            }
            this.serviceCollection.storageManager().getUserService().save(user.getUniqueId(), (IUserDataObject)((IDataObject)udo.get()));
            return res;
        }
        return false;
    }

    @Override
    public boolean clearNotes(User user) {
        Optional udo = this.serviceCollection.storageManager().getUserService().getOnThread(user.getUniqueId());
        if (udo.isPresent()) {
            ((IUserDataObject)udo.get()).remove(NoteKeys.NOTE_DATA);
            this.serviceCollection.storageManager().getUserService().save(user.getUniqueId(), (IUserDataObject)((IDataObject)udo.get()));
            return true;
        }
        return false;
    }
}

