/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerOnlineService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@EssentialsEquivalent(value={"near"})
@NonnullByDefault
@Command(aliases={"near"}, basePermission={"nucleus.near.base"}, commandDescriptionKey="near", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.near.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.near.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.near.exempt.cost")})
public class NearCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private static final NumberFormat formatter = NumberFormat.getInstance();
    private final String radiusKey = "radius";
    private int maxRadius;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(false, "nucleus.near.others"), GenericArguments.optionalWeak((CommandElement)GenericArguments.integer((Text)Text.of((String)this.radiusKey)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Vector3d position;
        Location location;
        User user = context.getUserFromArgs();
        if (user.isOnline()) {
            location = ((Player)user.getPlayer().get()).getLocation();
            position = location.getPosition();
        } else {
            World world = (World)user.getWorldUniqueId().flatMap(x -> Sponge.getServer().getWorld(x)).orElseThrow(() -> context.createException("command.near.location.nolocation", user.getName()));
            position = user.getPosition();
            location = new Location((Extent)world, position);
        }
        int radius = this.maxRadius;
        Optional<Integer> radiusOpt = context.getOne(this.radiusKey, Integer.class);
        if (radiusOpt.isPresent()) {
            int inputRadius = radiusOpt.get();
            if (inputRadius > this.maxRadius && context.testPermission("nucleus.near.exempt.maxradius")) {
                radius = inputRadius;
            } else {
                context.sendMessage("command.near.radiustoobig", this.maxRadius);
            }
        }
        CommandSource src = context.getCommandSource();
        IPlayerOnlineService playerOnlineService = context.getServiceCollection().playerOnlineService();
        List messagesToSend = ((World)location.getExtent()).getNearbyEntities(location.getPosition(), (double)radius).stream().filter(Player.class::isInstance).map(Player.class::cast).filter(e -> e.getUniqueId() != user.getUniqueId() && playerOnlineService.isOnline(src, (User)e)).map(x -> Tuple.of((Object)x, (Object)position.distance(x.getPosition()))).sorted(Comparator.comparingDouble(Tuple::getSecond)).map(tuple -> this.createPlayerLine(context, (Tuple<Player, Double>)tuple)).collect(Collectors.toList());
        Util.getPaginationBuilder(src).title(context.getMessage("command.near.playersnear", user.getName())).contents(messagesToSend).sendTo((MessageReceiver)src);
        return context.successResult();
    }

    private Text createPlayerLine(ICommandContext<? extends CommandSource> context, Tuple<Player, Double> player) {
        Text.Builder line = Text.builder();
        context.getMessage("command.near.playerdistancefrom", ((Player)player.getFirst()).getName());
        line.append(new Text[]{context.getMessage("command.near.playerdistancefrom", ((Player)player.getFirst()).getName(), formatter.format(Math.abs((Double)player.getSecond())))}).onClick((ClickAction)TextActions.runCommand((String)("/tp " + ((Player)player.getFirst()).getName()))).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.near.tpto", ((Player)player.getFirst()).getName())));
        return line.build();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        PlayerInfoConfig configAdapter = serviceCollection.moduleDataProvider().getModuleConfig(PlayerInfoConfig.class);
        this.maxRadius = configAdapter.getNear().getMaxRadius();
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

