/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import io.github.nucleuspowered.nucleus.modules.powertool.commands.PowertoolCommand;
import io.github.nucleuspowered.nucleus.modules.powertool.services.PowertoolService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"delete", "del", "rm", "remove"}, basePermission={"nucleus.powertool.base"}, commandDescriptionKey="powertool.delete", parentCommand=PowertoolCommand.class)
public class DeletePowertoolCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Optional itemStack = context.getCommandSource().getItemInHand(HandTypes.MAIN_HAND);
        if (!itemStack.isPresent()) {
            return context.errorResult("command.powertool.noitem", new Object[0]);
        }
        ItemStack inHand = (ItemStack)itemStack.get();
        ItemType type = inHand.getType();
        UUID uuid = context.getUniqueId().get();
        PowertoolService service = context.getServiceCollection().getServiceUnchecked(PowertoolService.class);
        service.getPowertoolForItem(uuid, type).orElseThrow(() -> context.createException("command.powertool.nocmds", Text.of((Translatable)inHand, (Object[])new Object[0])));
        service.clearPowertool(uuid, type);
        context.sendMessage("command.powertool.removed", Text.of((Translatable)inHand, (Object[])new Object[0]));
        return context.successResult();
    }
}

