/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rtp.commands;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import io.github.nucleuspowered.nucleus.api.module.rtp.NucleusRTPService;
import io.github.nucleuspowered.nucleus.api.module.rtp.kernel.RTPKernel;
import io.github.nucleuspowered.nucleus.modules.rtp.config.RTPConfig;
import io.github.nucleuspowered.nucleus.modules.rtp.events.RTPSelectedLocationEvent;
import io.github.nucleuspowered.nucleus.modules.rtp.options.RTPOptions;
import io.github.nucleuspowered.nucleus.modules.rtp.services.RTPService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.task.CostCancellableTask;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"rtp", "randomteleport", "rteleport"}, basePermission={"nucleus.rtp.base"}, commandDescriptionKey="rtp", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.rtp.exempt.cooldown", onCompletion=false), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.rtp.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.rtp.exempt.cost")}, associatedPermissions={"nucleus.rtp.others", "nucleus.rtp.worlds"})
public class RandomTeleportCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private RTPConfig rc = new RTPConfig();
    private final Map<Task, UUID> cachedTasks = new WeakHashMap<Task, UUID>();
    private final Timing TIMINGS;

    @Inject
    public RandomTeleportCommand(INucleusServiceCollection serviceCollection) {
        this.TIMINGS = Timings.of((Object)serviceCollection.pluginContainer(), (String)"RTP task");
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.rtp.others"), GenericArguments.optionalWeak((CommandElement)NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        World currentWorld;
        Player player = context.getPlayerFromArgs();
        Map<Task, UUID> map = this.cachedTasks;
        synchronized (map) {
            this.cachedTasks.keySet().removeIf(task -> !Sponge.getScheduler().getTaskById(task.getUniqueId()).isPresent());
            if (this.cachedTasks.containsValue(player.getUniqueId())) {
                return context.errorResult("command.rtp.inprogress", player.getName());
            }
        }
        WorldProperties wp = this.rc.getDefaultWorld().isPresent() ? context.getOne("world", WorldProperties.class).orElseGet(() -> this.rc.getDefaultWorld().get()) : context.getWorldPropertiesOrFromSelf("world").get();
        if (this.rc.isPerWorldPermissions()) {
            String name = wp.getWorldName();
            if (!context.testPermission("nucleus.rtp.worlds." + name.toLowerCase())) {
                return context.errorResult("command.rtp.worldnoperm", name);
            }
        }
        if ((currentWorld = (World)Sponge.getServer().loadWorld(wp.getUniqueId()).orElse(null)) == null) {
            currentWorld = (World)Sponge.getServer().loadWorld(wp).orElseThrow(() -> context.createException("command.rtp.worldnoload", wp.getWorldName()));
        }
        context.sendMessage("command.rtp.searching", new Object[0]);
        RTPOptions options = new RTPOptions(this.rc, currentWorld.getName());
        RTPTask rtask = new RTPTask(context.getServiceCollection().pluginContainer(), currentWorld, context, player, this.rc.getNoOfAttempts(), options, context.getServiceCollection().getServiceUnchecked(RTPService.class).getKernel(wp), context.is(player) ? context.getCost() : 0.0);
        Task task2 = Sponge.getScheduler().createTaskBuilder().execute((Consumer)rtask).submit((Object)context.getServiceCollection().pluginContainer());
        this.cachedTasks.put(task2, player.getUniqueId());
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.rc = serviceCollection.moduleDataProvider().getModuleConfig(RTPConfig.class);
    }

    static /* synthetic */ Timing access$100(RandomTeleportCommand x0) {
        return x0.TIMINGS;
    }

    private class RTPTask
    extends CostCancellableTask {
        private final PluginContainer pluginContainer;
        private final Cause cause;
        private final World targetWorld;
        private final ICommandContext<? extends CommandSource> source;
        private final Player target;
        private final boolean isSelf;
        private final Logger logger;
        private int count;
        private final int maxCount;
        private final NucleusRTPService.RTPOptions options;
        private final RTPKernel kernel;

        private RTPTask(PluginContainer pluginContainer, World target, ICommandContext<? extends CommandSource> source, Player target1, int maxCount, NucleusRTPService.RTPOptions options, RTPKernel kernel, double cost) {
            super(source.getServiceCollection(), (CommandSource)target1, cost);
            this.logger = source.getServiceCollection().logger();
            this.pluginContainer = pluginContainer;
            this.cause = Sponge.getCauseStackManager().getCurrentCause();
            this.targetWorld = target;
            this.source = source;
            this.target = target1;
            this.isSelf = source.getCommandSourceUnchecked() instanceof Player && source.getCommandSourceAsPlayerUnchecked().getUniqueId().equals(target1.getUniqueId());
            this.maxCount = maxCount;
            this.count = maxCount;
            this.options = options;
            this.kernel = kernel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(Task task) {
            block27: {
                block28: {
                    block25: {
                        block26: {
                            --this.count;
                            if (!this.target.isOnline()) {
                                this.onCancel();
                                return;
                            }
                            dummy = RandomTeleportCommand.access$100(RandomTeleportCommand.this).startTiming();
                            var3_3 = null;
                            try {
                                this.logger.debug(String.format("RTP of %s, attempt %s of %s", new Object[]{this.target.getName(), this.maxCount - this.count, this.maxCount}));
                                counter = 0;
                                while (++counter <= 10) {
                                    try {
                                        optionalLocation = this.kernel.getLocation((Location<World>)this.target.getLocation(), this.targetWorld, this.options);
                                        if (!optionalLocation.isPresent()) continue;
                                        targetLocation = optionalLocation.get();
                                        if (Sponge.getEventManager().post((Event)new RTPSelectedLocationEvent(targetLocation, this.target, this.cause))) continue;
                                        this.source.getServiceCollection().logger().debug(String.format("RTP of %s, found location %s, %s, %s", new Object[]{this.target.getName(), String.valueOf(targetLocation.getBlockX()), String.valueOf(targetLocation.getBlockY()), String.valueOf(targetLocation.getBlockZ())}));
                                        if (this.source.getServiceCollection().teleportService().setLocation(this.target, targetLocation)) {
                                            if (!this.isSelf) {
                                                this.source.sendMessageTo((MessageReceiver)this.target, "command.rtp.other", new Object[0]);
                                                this.source.sendMessage("command.rtp.successother", new Object[]{this.target.getName(), targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ()});
                                            }
                                            this.source.sendMessageTo((MessageReceiver)this.target, "command.rtp.success", new Object[]{targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ()});
                                            if (this.isSelf) {
                                                this.source.getServiceCollection().cooldownService().setCooldown(this.source.getCommandKey(), (Identifiable)this.target, Duration.ofSeconds(this.source.getServiceCollection().commandMetadataService().getControl(RandomTeleportCommand.class).orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()).getCooldown((Subject)this.target)));
                                                var7_10 = RandomTeleportCommand.access$200(RandomTeleportCommand.this);
                                                synchronized (var7_10) {
                                                    RandomTeleportCommand.access$200(RandomTeleportCommand.this).remove(task);
                                                }
                                            }
                                            if (dummy == null) return;
                                            if (var3_3 == null) break block25;
                                            break block26;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (PositionOutOfBoundsException var5_8) {
                                    }
                                }
                                break block27;
                            }
                            catch (Throwable var4_6) {
                                try {
                                    var3_3 = var4_6;
                                    throw var4_6;
                                }
                                catch (Throwable var9_13) {
                                    if (dummy == null) throw var9_13;
                                    if (var3_3 == null) {
                                        dummy.close();
                                        throw var9_13;
                                    }
                                    try {
                                        dummy.close();
                                        throw var9_13;
                                    }
                                    catch (Throwable var10_14) {
                                        var3_3.addSuppressed(var10_14);
                                        throw var9_13;
                                    }
                                }
                            }
                        }
                        try {
                            dummy.close();
                            return;
                        }
                        catch (Throwable var7_11) {
                            var3_3.addSuppressed(var7_11);
                            return;
                        }
                    }
                    dummy.close();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        this.source.sendMessage("command.rtp.cancelled", new Object[0]);
                        this.onCancel();
                        if (dummy == null) return;
                        if (var3_3 == null) break block28;
                    }
                    try {
                        dummy.close();
                        return;
                    }
                    catch (Throwable var7_12) {
                        var3_3.addSuppressed(var7_12);
                        return;
                    }
                }
                dummy.close();
                return;
            }
            this.onUnsuccesfulAttempt(task);
            if (dummy == null) return;
            if (var3_3 != null) {
                try {
                    dummy.close();
                    return;
                }
                catch (Throwable var4_5) {
                    var3_3.addSuppressed(var4_5);
                    return;
                }
            }
            dummy.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUnsuccesfulAttempt(Task task) {
            Map map = RandomTeleportCommand.this.cachedTasks;
            synchronized (map) {
                if (this.count <= 0) {
                    this.source.getServiceCollection().logger().debug(String.format("RTP of %s was unsuccessful", this.target.getName()));
                    this.source.sendMessage("command.rtp.error", new Object[0]);
                    this.onCancel();
                } else {
                    RandomTeleportCommand.this.cachedTasks.put(Sponge.getScheduler().createTaskBuilder().delayTicks(2L).execute((Consumer)this).submit((Object)this.pluginContainer), this.target.getUniqueId());
                }
                RandomTeleportCommand.this.cachedTasks.remove(task);
            }
        }
    }
}

