/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.commands;

import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.module.spawn.event.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.modules.spawn.helpers.SpawnHelper;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@EssentialsEquivalent(value={"spawn"})
@NonnullByDefault
@Command(aliases={"spawn"}, basePermission={"nucleus.spawn.base"}, commandDescriptionKey="spawn", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.spawn.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.spawn.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.spawn.exempt.cost")}, associatedPermissions={"nucleus.spawn.force", "nucleus.spawn.otherworlds", "nucleus.spawn.worlds"})
public class SpawnCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private SpawnConfig sc = new SpawnConfig();

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.sc = serviceCollection.moduleDataProvider().getModuleConfig(SpawnConfig.class);
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.spawn.force", new String[]{"f", "-force"}).buildWith(GenericArguments.optional((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection), "nucleus.spawn.otherworlds", true)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        boolean force = context.hasAny("f");
        Player src = context.getIfPlayer();
        GlobalSpawnConfig gsc = this.sc.getGlobalSpawn();
        WorldProperties wp = context.getOne("world", WorldProperties.class).orElseGet(() -> gsc.isOnSpawnCommand() ? gsc.getWorld().orElse(src.getWorld().getProperties()) : src.getWorld().getProperties());
        Optional ow = Sponge.getServer().loadWorld(wp.getUniqueId());
        if (!ow.isPresent()) {
            return context.errorResult("command.spawn.noworld", new Object[0]);
        }
        if (this.sc.isPerWorldPerms() && !context.testPermission("nucleus.spawn.worlds." + ((World)ow.get()).getName().toLowerCase())) {
            return context.errorResult("command.spawn.nopermsworld", ((World)ow.get()).getName());
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContexts.SPAWN_EVENT_TYPE, (Object)NucleusSendToSpawnEvent.Type.COMMAND);
            SendToSpawnEvent event = new SendToSpawnEvent(SpawnHelper.getSpawn(((World)ow.get()).getProperties(), src, context), (User)src, frame.getCurrentCause());
            if (Sponge.getEventManager().post((Event)event)) {
                if (event.getCancelReason().isPresent()) {
                    ICommandResult iCommandResult = context.errorResult("command.spawnother.self.failed.reason", event.getCancelReason().get());
                    return iCommandResult;
                }
                ICommandResult iCommandResult = context.errorResult("command.spawnother.self.failed.noreason", new Object[0]);
                return iCommandResult;
            }
            TeleportResult result = context.getServiceCollection().teleportService().teleportPlayerSmart(src, event.getTransformTo(), true, !force && this.sc.isSafeTeleport(), TeleportScanners.NO_SCAN.get());
            if (result.isSuccessful()) {
                context.sendMessage("command.spawn.success", wp.getWorldName());
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
            if (result == TeleportResult.FAIL_NO_LOCATION) {
                ICommandResult iCommandResult = context.errorResult("command.spawn.fail", wp.getWorldName());
                return iCommandResult;
            }
            ICommandResult iCommandResult = context.errorResult("command.spawn.cancelled", wp.getWorldName());
            return iCommandResult;
        }
    }
}

