/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat.commands;

import io.github.nucleuspowered.nucleus.modules.staffchat.services.StaffChatService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"toggleviewstaffchat", "vsc", "togglevsc"}, basePermission={"nucleus.staffchat.base"}, commandDescriptionKey="toggleviewstaffchat")
public class ToggleStaffChatCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        IUserPreferenceService ups = context.getServiceCollection().userPreferenceService();
        Player src = context.getIfPlayer();
        boolean result = context.getOne("true|false", Boolean.class).orElseGet(() -> ups.getPreferenceFor((User)src, NucleusKeysProvider.VIEW_STAFF_CHAT).orElse(true));
        ups.setPreferenceFor((User)src, NucleusKeysProvider.VIEW_STAFF_CHAT, !result);
        StaffChatService service = context.getServiceCollection().getServiceUnchecked(StaffChatService.class);
        if (!result && service.isToggledChat(src)) {
            service.toggle(src, false);
        }
        context.sendMessage("command.staffchat.view." + (result ? "on" : "off"), new Object[0]);
        return context.successResult();
    }
}

