/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.events.RequestEvent;
import io.github.nucleuspowered.nucleus.modules.teleport.services.PlayerTeleporterService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@NotifyIfAFK(value={"player"})
@Command(aliases={"tpa", "teleportask", "call", "tpask"}, basePermission={"nucleus.teleport.tpa.base"}, commandDescriptionKey="tpa", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.teleport.tpa.exempt.warmup", onExecute=false), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.teleport.tpa.exempt.cooldown", onCompletion=false), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.teleport.tpa.exempt.cost")}, associatedPermissions={"nucleus.teleport.tptoggle.exempt", "nucleus.teleport.tpa.force"})
@EssentialsEquivalent(value={"tpa", "call", "tpask"})
public class TeleportAskCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean isCooldownOnAsk = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.teleport.tpa.force", new String[]{"f"}).buildWith(NucleusParameters.ONE_PLAYER.get(serviceCollection))};
    }

    @Override
    public Optional<ICommandResult> preExecute(ICommandContext.Mutable<? extends Player> context) throws CommandException {
        boolean canTeleport = context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class).canTeleportTo((CommandSource)context.getIfPlayer(), (User)context.requireOne("player", Player.class));
        if (canTeleport) {
            return Optional.empty();
        }
        return Optional.of(context.failResult());
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player target = context.requireOne("player", Player.class);
        if (context.is(target)) {
            return context.errorResult("command.teleport.self", new Object[0]);
        }
        RequestEvent.CauseToPlayer event = new RequestEvent.CauseToPlayer(context.getCause(), target);
        if (Sponge.getEventManager().post((Event)event)) {
            if (event.getCancelMessage().isPresent()) {
                return context.errorResultLiteral(event.getCancelMessage().get());
            }
            return context.errorResult("command.tpa.eventfailed", new Object[0]);
        }
        Consumer<Player> cooldownSetter = player -> {};
        if (this.isCooldownOnAsk) {
            this.setCooldown(context);
        } else {
            cooldownSetter = player -> this.setCooldown(context);
        }
        context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class).requestTeleport(context.getIfPlayer(), target, context.getCost(), context.getWarmup(), context.getIfPlayer(), target, context.getOne("f", Boolean.TYPE).orElse(false) == false, false, false, cooldownSetter, "command.tpa.question");
        return context.successResult();
    }

    private void setCooldown(ICommandContext<? extends Player> context) {
        try {
            context.getServiceCollection().cooldownService().setCooldown(context.getCommandKey(), (Identifiable)context.getIfPlayer(), Duration.ofSeconds(context.getCooldown()));
        }
        catch (CommandException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.isCooldownOnAsk = serviceCollection.moduleDataProvider().getModuleConfig(TeleportConfig.class).isCooldownOnAsk();
    }
}

