/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.services;

import io.github.nucleuspowered.nucleus.modules.teleport.services.TeleportTask;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.World;

public class TeleportRequest
extends TeleportTask {
    private final Instant expiry;
    private boolean forcedExpired;
    private boolean expired;

    public TeleportRequest(INucleusServiceCollection serviceCollection, UUID toTeleport, UUID target, Instant expiry, double cost, int warmup, @Nullable UUID requester, boolean safe, boolean silentTarget, boolean silentSource, @Nullable Transform<World> requestLocation, @Nullable Consumer<Player> successCallback) {
        super(serviceCollection, toTeleport, target, cost, warmup, safe, silentSource, silentTarget, requestLocation, requester, successCallback);
        this.expiry = expiry;
    }

    public Optional<Player> getToBeTeleported() {
        return Sponge.getServer().getPlayer(this.toTeleport);
    }

    public Optional<Player> getTarget() {
        return Sponge.getServer().getPlayer(this.target);
    }

    public void forceExpire(boolean callback) {
        if (!callback || this.isActive()) {
            this.forcedExpired = true;
            if (callback) {
                this.onCancel();
            }
        }
    }

    public boolean isActive() {
        if (!this.expired) {
            boolean bl = this.expired = this.forcedExpired && Instant.now().isAfter(this.expiry);
            if (this.expired) {
                this.onCancel();
            }
        }
        return !this.forcedExpired;
    }

    public Instant getExpiryTime() {
        return this.expiry;
    }
}

