/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.services;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.teleport.services.PlayerTeleporterService;
import io.github.nucleuspowered.nucleus.scaffold.task.CancellableTask;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.World;

public class TeleportTask
implements CancellableTask {
    final UUID toTeleport;
    protected final UUID target;
    protected final double cost;
    protected final boolean safe;
    protected final int warmup;
    @Nullable
    private final UUID requester;
    private final boolean silentSource;
    private final boolean silentTarget;
    @Nullable
    private final Transform<World> requestLocation;
    @Nullable
    private Consumer<Player> successCallback;
    private final INucleusServiceCollection serviceCollection;

    public TeleportTask(INucleusServiceCollection serviceCollection, UUID toTeleport, UUID target, double cost, int warmup, boolean safe, boolean silentSource, boolean silentTarget, @Nullable Transform<World> requestLocation, @Nullable UUID requester, @Nullable Consumer<Player> successCallback) {
        this.toTeleport = toTeleport;
        this.target = target;
        this.cost = cost;
        this.warmup = warmup;
        this.safe = safe;
        this.silentSource = silentSource;
        this.silentTarget = silentTarget;
        this.requester = requester;
        this.successCallback = successCallback;
        this.requestLocation = requestLocation;
        this.serviceCollection = serviceCollection;
    }

    @Override
    public void onCancel() {
        PlayerTeleporterService.onCancel(this.serviceCollection, this.requester, this.toTeleport, this.cost);
    }

    @Override
    public void accept(Task task) {
        this.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        ConsoleSource receiver;
        Player teleportingPlayer = Sponge.getServer().getPlayer(this.toTeleport).orElse(null);
        Player targetPlayer = Sponge.getServer().getPlayer(this.target).orElse(null);
        User source = Util.getUserFromUUID(this.requester).orElse(null);
        Object object = receiver = source != null && source.isOnline() ? (CommandSource)source.getPlayer().get() : Sponge.getServer().getConsole();
        if (teleportingPlayer != null && targetPlayer != null) {
            INucleusTeleportService tpHandler = this.serviceCollection.teleportService();
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                if (source == null) {
                    frame.pushCause((Object)Sponge.getServer().getConsole());
                } else {
                    frame.pushCause((Object)source);
                }
                TeleportResult result = tpHandler.teleportPlayerSmart(teleportingPlayer, this.requestLocation == null ? targetPlayer.getTransform() : this.requestLocation, false, this.safe, TeleportScanners.NO_SCAN.get());
                if (!result.isSuccessful()) {
                    if (!this.silentSource) {
                        this.serviceCollection.messageProvider().sendMessageTo((CommandSource)receiver, result == TeleportResult.FAIL_NO_LOCATION ? "teleport.nosafe" : "teleport.cancelled");
                    }
                    this.onCancel();
                    return;
                }
                if (!this.toTeleport.equals(this.requester) && !this.silentSource) {
                    this.serviceCollection.messageProvider().sendMessageTo((CommandSource)receiver, "teleport.success.source", teleportingPlayer.getName(), targetPlayer.getName());
                }
                this.serviceCollection.messageProvider().sendMessageTo((CommandSource)teleportingPlayer, "teleport.to.success", targetPlayer.getName());
                if (!this.silentTarget) {
                    this.serviceCollection.messageProvider().sendMessageTo((CommandSource)targetPlayer, "teleport.from.success", teleportingPlayer.getName());
                }
                if (this.successCallback == null || source == null) return;
                source.getPlayer().ifPresent(x -> this.successCallback.accept((Player)x));
                return;
            }
        } else {
            if (!this.silentSource) {
                this.serviceCollection.messageProvider().sendMessageTo((CommandSource)receiver, "teleport.fail.offline");
            }
            this.onCancel();
        }
    }
}

