/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.commands;

import io.github.nucleuspowered.nucleus.modules.vanish.VanishKeys;
import io.github.nucleuspowered.nucleus.modules.vanish.services.VanishService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.IKeyedDataObject;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"vanish", "v"})
@Command(aliases={"vanish", "v"}, basePermission={"nucleus.vanish.base"}, commandDescriptionKey="vanish", associatedPermissions={"nucleus.vanish.see", "nucleus.vanish.persist"})
public class VanishCommand
implements ICommandExecutor<CommandSource> {
    private final String b = "toggle";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(false, "nucleus.vanish.others"), GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.bool((Text)Text.of((String)this.b))))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        boolean result;
        User ou = context.getUserFromArgs();
        if (ou.getPlayer().isPresent()) {
            return this.onPlayer(context, (Player)ou.getPlayer().get());
        }
        if (!context.testPermissionFor((Subject)ou, "persist")) {
            return context.errorResult("command.vanish.noperm", ou.getName());
        }
        try (IKeyedDataObject.Value<Boolean> value = ((IUserDataObject)context.getServiceCollection().storageManager().getUserService().getOrNewOnThread(ou.getUniqueId())).getAndSet(VanishKeys.VANISH_STATUS);){
            result = context.getOne(this.b, Boolean.class).orElseGet(() -> value.getValue().orElse(false) == false);
            value.setValue(result);
            VanishService service = context.getServiceCollection().getServiceUnchecked(VanishService.class);
            if (result) {
                service.vanishPlayer(ou);
            } else {
                service.unvanishPlayer(ou);
            }
        }
        context.sendMessage("command.vanish.successuser", ou.getName(), result ? "loc:command.vanish.vanished" : "loc:command.vanish.visible");
        return context.successResult();
    }

    private ICommandResult onPlayer(ICommandContext<? extends CommandSource> context, Player playerToVanish) throws CommandException {
        if (playerToVanish.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET).equals(GameModes.SPECTATOR)) {
            return context.errorResult("command.vanish.fail", new Object[0]);
        }
        boolean toVanish = context.getOne(this.b, Boolean.class).orElse(playerToVanish.get(Keys.VANISH).orElse(false) == false);
        VanishService service = context.getServiceCollection().getServiceUnchecked(VanishService.class);
        if (toVanish) {
            service.vanishPlayer((User)playerToVanish);
        } else {
            service.unvanishPlayer((User)playerToVanish);
        }
        context.sendMessageTo((MessageReceiver)playerToVanish, "command.vanish.success", toVanish ? "loc:command.vanish.vanished" : "loc:command.vanish.visible");
        if (!context.is(playerToVanish)) {
            context.sendMessage("command.vanish.successplayer", context.getDisplayName(playerToVanish.getUniqueId()), toVanish ? "loc:command.vanish.vanished" : "loc:command.vanish.visible");
        }
        return context.successResult();
    }
}

