/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfig;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveDoubleArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"cost", "setcost"}, basePermission={"nucleus.warp.cost.base"}, commandDescriptionKey="warp.cost", async=true, parentCommand=WarpCommand.class)
public class SetCostCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String costKey = "cost";
    private double defaultCost = 0.0;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(WarpService.class).warpElement(false), GenericArguments.onlyOne((CommandElement)new PositiveDoubleArgument((Text)Text.of((String)this.costKey), serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Warp warpData = context.requireOne("warp", Warp.class);
        double cost = context.requireOne(this.costKey, Double.class);
        if (cost < -1.0) {
            return context.errorResult("command.warp.costset.arg", new Object[0]);
        }
        WarpService warpService = context.getServiceCollection().getServiceUnchecked(WarpService.class);
        if (cost == -1.0 && warpService.setWarpCost(warpData.getName(), -1.0)) {
            context.sendMessage("command.warp.costset.reset", warpData.getName(), String.valueOf(this.defaultCost));
            return context.successResult();
        }
        if (warpService.setWarpCost(warpData.getName(), cost)) {
            context.sendMessage("command.warp.costset.success", warpData.getName(), cost);
            return context.successResult();
        }
        return context.errorResult("command.warp.costset.failed", warpData.getName());
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.defaultCost = serviceCollection.moduleDataProvider().getModuleConfig(WarpConfig.class).getDefaultWarpCost();
    }
}

