/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.world.commands.ListWorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.ArrayList;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"info"}, basePermission={"nucleus.world.list.base"}, commandDescriptionKey="world.info", parentCommand=WorldCommand.class)
public class InfoWorldCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ALL.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties wp = context.getWorldPropertiesOrFromSelf("world").orElseThrow(() -> context.createException("command.world.player", new Object[0]));
        ArrayList listContent = Lists.newArrayList();
        boolean canSeeSeeds = context.testPermission("nucleus.world.list.seed");
        ListWorldCommand.getWorldInfo(context, listContent, wp, canSeeSeeds);
        Util.getPaginationBuilder(context.getCommandSourceUnchecked()).contents((Iterable)listContent).title(context.getMessage("command.world.info.title", wp.getWorldName())).sendTo((MessageReceiver)context.getCommandSourceUnchecked());
        return context.successResult();
    }
}

