/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"setspawn"}, basePermission={"nucleus.world.setspawn.base"}, commandDescriptionKey="world.setspawn", parentCommand=WorldCommand.class)
public class SetSpawnWorldCommand
implements ICommandExecutor<CommandSource> {
    private final String xKey = "x";
    private final String yKey = "y";
    private final String zKey = "z";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.seq((CommandElement[])new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection), GenericArguments.integer((Text)Text.of((String)this.xKey)), GenericArguments.integer((Text)Text.of((String)this.yKey)), GenericArguments.integer((Text)Text.of((String)this.zKey))}))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties world = context.getWorldPropertiesOrFromSelf("world").orElseThrow(() -> context.createException("command.world.player", new Object[0]));
        Vector3i loc = context.hasAny(this.xKey) ? new Vector3i(context.requireOne(this.xKey, Integer.class).intValue(), context.requireOne(this.yKey, Integer.class).intValue(), context.requireOne(this.zKey, Integer.class).intValue()) : ((Locatable)context.getCommandSource()).getLocation().getBlockPosition();
        world.setSpawnPosition(loc);
        context.sendMessage("command.world.setspawn.success", new Object[0]);
        return context.successResult();
    }
}

