/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.modules.spawn.SpawnKeys;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@EssentialsEquivalent(value={"world"}, notes="The world command in Essentials was just a warp command.")
@Command(aliases={"teleport", "tp"}, basePermission={"nucleus.world.teleport.base"}, commandDescriptionKey="world.teleport", parentCommand=WorldCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.world.teleport.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.world.teleport.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.world.teleport.exempt.cost")}, associatedPermissions={"nucleus.world.teleport.others", "nucleus.worlds"})
public class TeleportWorldCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection), serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.world.teleport.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Vector3d pos;
        Player player = context.getPlayerFromArgs("player", "command.world.player");
        WorldProperties worldProperties = context.requireOne("world", WorldProperties.class);
        if (!worldProperties.isEnabled()) {
            return context.errorResult("command.world.teleport.notenabled", worldProperties.getWorldName());
        }
        World world = (World)Sponge.getServer().loadWorld(worldProperties.getUniqueId()).orElseThrow(() -> context.createException("command.world.teleport.failed", worldProperties.getWorldName()));
        if (!player.transferToWorld(world, pos = worldProperties.getSpawnPosition().toDouble())) {
            return context.errorResult("command.world.teleport.failed", worldProperties.getWorldName());
        }
        if (context.getServiceCollection().moduleDataProvider().isLoaded("spawn")) {
            context.getServiceCollection().storageManager().getWorldService().getOnThread(worldProperties.getUniqueId()).flatMap(x -> x.get(SpawnKeys.WORLD_SPAWN_ROTATION)).ifPresent(y -> new Transform((Extent)world, pos, y));
        }
        if (context.is(player)) {
            context.sendMessage("command.world.teleport.success", worldProperties.getWorldName());
        } else {
            context.sendMessage("command.world.teleport.successplayer", context.getServiceCollection().playerDisplayNameService().getDisplayName(player), worldProperties.getWorldName());
            context.sendMessageTo((MessageReceiver)player, "command.world.teleport.success", worldProperties.getWorldName());
        }
        return context.successResult();
    }
}

