/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands.border;

import io.github.nucleuspowered.nucleus.modules.world.commands.border.BorderCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"reset"}, basePermission={"nucleus.world.border.set.base"}, commandDescriptionKey="world.border.reset", parentCommand=BorderCommand.class)
public class ResetBorderCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_WORLD_PROPERTIES_ALL.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties wp = context.getWorldPropertiesOrFromSelf("world").orElseThrow(() -> context.createException("command.world.player", new Object[0]));
        wp.setWorldBorderCenter(0.0, 0.0);
        Optional world = Sponge.getServer().getWorld(wp.getUniqueId());
        World toDiameter = world.orElseGet(() -> (World)Sponge.getServer().getWorld(((WorldProperties)Sponge.getServer().getDefaultWorld().orElseThrow(IllegalStateException::new)).getUniqueId()).orElseThrow(IllegalStateException::new));
        long diameter = Math.abs(toDiameter.getBiomeMax().getX() - toDiameter.getBiomeMin().getX()) + 1;
        wp.setWorldBorderDiameter((double)diameter);
        world.ifPresent(w -> {
            w.getWorldBorder().setCenter(0.0, 0.0);
            w.getWorldBorder().setDiameter((double)diameter);
        });
        context.sendMessage("command.world.setborder.set", wp.getWorldName(), "0", "0", String.valueOf(diameter));
        return context.successResult();
    }
}

