/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.quickstart;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.api.core.exception.ModulesLoadedException;
import io.github.nucleuspowered.nucleus.api.core.exception.NoModuleException;
import io.github.nucleuspowered.nucleus.api.core.exception.UnremovableModuleException;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ConstructionPhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleLoaderException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.UndisableableModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.holders.DiscoveryModuleHolder;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.spongepowered.api.plugin.PluginContainer;

public class ModuleRegistrationProxyService {
    private final INucleusServiceCollection serviceCollection;
    private final Supplier<DiscoveryModuleHolder<?, ?>> moduleHolder;

    @Inject
    public ModuleRegistrationProxyService(INucleusServiceCollection serviceCollection, Supplier<DiscoveryModuleHolder<?, ?>> holder) {
        this.serviceCollection = serviceCollection;
        this.moduleHolder = holder;
    }

    public boolean canDisableModules() {
        return this.moduleHolder.get().getCurrentPhase() == ConstructionPhase.DISCOVERED;
    }

    public void removeModule(String module, PluginContainer plugin) throws ModulesLoadedException, UnremovableModuleException, NoModuleException {
        if (!this.canDisableModules()) {
            throw new ModulesLoadedException();
        }
        Preconditions.checkNotNull((Object)plugin);
        Logger logger = this.serviceCollection.logger();
        IMessageProviderService messageProviderService = this.serviceCollection.messageProvider();
        try {
            this.moduleHolder.get().disableModule(module);
            logger.info(messageProviderService.getMessageString("nucleus.module.disabled.modulerequest", plugin.getName(), plugin.getId(), module));
        }
        catch (IllegalStateException e) {
            throw new ModulesLoadedException();
        }
        catch (UndisableableModuleException e) {
            logger.warn(messageProviderService.getMessageString("nucleus.module.disabled.forceload", plugin.getName(), plugin.getId(), module));
            logger.warn(messageProviderService.getMessageString("nucleus.module.disabled.forceloadtwo", plugin.getName()));
            throw new UnremovableModuleException();
        }
        catch (io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException e) {
            throw new NoModuleException();
        }
        catch (QuickStartModuleLoaderException e) {
            e.printStackTrace();
        }
    }
}

