/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.quickstart.event;

import io.github.nucleuspowered.nucleus.NucleusBootstrap;
import io.github.nucleuspowered.nucleus.api.core.event.NucleusModuleEvent;
import io.github.nucleuspowered.nucleus.api.core.exception.ModulesLoadedException;
import io.github.nucleuspowered.nucleus.api.core.exception.NoModuleException;
import io.github.nucleuspowered.nucleus.api.core.exception.UnremovableModuleException;
import io.github.nucleuspowered.nucleus.quickstart.ModuleRegistrationProxyService;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class BaseModuleEvent
extends AbstractEvent
implements NucleusModuleEvent {
    private final NucleusBootstrap plugin;
    private final Cause cause = Sponge.getCauseStackManager().getCurrentCause();
    private final Map<String, NucleusModuleEvent.ModuleEnableState> state;

    private BaseModuleEvent(NucleusBootstrap plugin) {
        this.plugin = plugin;
        this.state = this.getState();
    }

    @Override
    public Map<String, NucleusModuleEvent.ModuleEnableState> getModuleList() {
        return this.state;
    }

    public Cause getCause() {
        return this.cause;
    }

    Map<String, NucleusModuleEvent.ModuleEnableState> getState() {
        return this.plugin.getModuleHolder().getModulesWithLoadingState().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> this.getFromLoadingStatus((LoadingStatus)((Object)((Object)v.getValue())))));
    }

    private NucleusModuleEvent.ModuleEnableState getFromLoadingStatus(LoadingStatus status) {
        if (status == LoadingStatus.DISABLED) {
            return NucleusModuleEvent.ModuleEnableState.DISABLED;
        }
        if (status == LoadingStatus.ENABLED) {
            return NucleusModuleEvent.ModuleEnableState.ENABLED;
        }
        return NucleusModuleEvent.ModuleEnableState.FORCE_ENABLED;
    }

    public static class Enabled
    extends BaseModuleEvent
    implements NucleusModuleEvent.Enabled {
        public Enabled(NucleusBootstrap plugin) {
            super(plugin);
        }
    }

    public static class PreEnable
    extends BaseModuleEvent
    implements NucleusModuleEvent.PreEnable {
        public PreEnable(NucleusBootstrap plugin) {
            super(plugin);
        }
    }

    public static class Complete
    extends BaseModuleEvent
    implements NucleusModuleEvent.Complete {
        public Complete(NucleusBootstrap plugin) {
            super(plugin);
        }
    }

    public static class AboutToEnable
    extends BaseModuleEvent
    implements NucleusModuleEvent.AboutToEnable {
        public AboutToEnable(NucleusBootstrap plugin) {
            super(plugin);
        }
    }

    public static class AboutToConstructEvent
    extends BaseModuleEvent
    implements NucleusModuleEvent.AboutToConstruct {
        public AboutToConstructEvent(NucleusBootstrap plugin) {
            super(plugin);
        }

        @Override
        public Map<String, NucleusModuleEvent.ModuleEnableState> getModuleList() {
            return this.getState();
        }

        @Override
        public void disableModule(String module, PluginContainer plugin) throws UnremovableModuleException, NoModuleException {
            try {
                ((ModuleRegistrationProxyService)Sponge.getServiceManager().provideUnchecked(ModuleRegistrationProxyService.class)).removeModule(module, plugin);
            }
            catch (ModulesLoadedException e) {
                e.printStackTrace();
            }
        }
    }
}

