/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command;

import io.github.nucleuspowered.nucleus.scaffold.command.NucleusArgumentParseException;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tuple;

public class NucleusCommandException
extends CommandException {
    private final boolean allowFallback;
    private final List<Tuple<String, CommandException>> exceptions;
    private final IMessageProviderService messageProvider;
    private Boolean overrideUsage = null;

    public NucleusCommandException(List<Tuple<String, CommandException>> exception, boolean allowFallback, IMessageProviderService messageProviderService) {
        super(Text.EMPTY);
        this.exceptions = exception;
        this.allowFallback = allowFallback;
        this.messageProvider = messageProviderService;
    }

    public List<Tuple<String, CommandException>> getExceptions() {
        return this.exceptions;
    }

    @Nullable
    public Text getText() {
        if (this.exceptions.isEmpty()) {
            return this.messageProvider.getMessage("command.exception.nomoreinfo");
        }
        if (this.exceptions.stream().allMatch(x -> x.getSecond() instanceof CommandPermissionException)) {
            return ((CommandException)((Object)this.exceptions.get(0).getSecond())).getText();
        }
        if (this.exceptions.stream().allMatch(x -> {
            CommandException e = (CommandException)((Object)((Object)x.getSecond()));
            return e instanceof NucleusArgumentParseException && ((NucleusArgumentParseException)((Object)((Object)((Object)e)))).isEnd();
        })) {
            if (this.exceptions.size() == 1) {
                Tuple<String, CommandException> exceptionTuple = this.exceptions.get(0);
                return Text.of((Object[])new Object[]{this.messageProvider.getMessage("command.exception.fromcommand", (String)exceptionTuple.getFirst()), Text.NEW_LINE, TextColors.RED, ((CommandException)((Object)exceptionTuple.getSecond())).getText()});
            }
            return this.print(this.exceptions);
        }
        List<Tuple<String, CommandException>> lce = this.exceptions.stream().filter(x -> {
            CommandException e = (CommandException)((Object)((Object)x.getSecond()));
            return !(e instanceof NucleusArgumentParseException) || !((NucleusArgumentParseException)((Object)((Object)((Object)e)))).isEnd();
        }).filter(x -> !CommandPermissionException.class.isInstance(x)).collect(Collectors.toList());
        if (lce.size() == 1) {
            Tuple<String, CommandException> exceptionTuple = this.exceptions.get(0);
            return Text.of((Object[])new Object[]{this.messageProvider.getMessage("command.exception.fromcommand", (String)exceptionTuple.getFirst()), Text.NEW_LINE, TextColors.RED, ((CommandException)((Object)exceptionTuple.getSecond())).getText()});
        }
        return this.print(lce);
    }

    private Text print(List<Tuple<String, CommandException>> lce) {
        Text sept = this.messageProvider.getMessage("command.exception.separator");
        Text.Builder builder = this.messageProvider.getMessage("command.exception.multiple").toBuilder();
        lce.forEach(x -> builder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{sept}).append(new Text[]{Text.NEW_LINE}).append(new Text[]{this.messageProvider.getMessage("command.exception.fromcommand", (String)x.getFirst())}).append(new Text[]{Text.NEW_LINE}).append(new Text[]{((CommandException)((Object)((Object)x.getSecond()))).getText()}));
        builder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{sept});
        return builder.toText();
    }

    public void setOverrideUsage(Boolean overrideUsage) {
        this.overrideUsage = overrideUsage;
    }

    public boolean shouldIncludeUsage() {
        return this.overrideUsage == null ? super.shouldIncludeUsage() : this.overrideUsage.booleanValue();
    }

    public boolean isAllowFallback() {
        return this.allowFallback;
    }
}

