/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.modifier.impl;

import io.github.nucleuspowered.nucleus.api.core.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.config.CommandModifiersConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.time.Duration;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class WarmupModifier
implements ICommandModifier {
    private static final String WARMUP = "warmup";

    public String getId() {
        return "nucleus:has_warmup";
    }

    public String getName() {
        return "Warmup Modifier";
    }

    @Override
    public void getDefaultNode(ConfigurationNode node, IMessageProviderService messageProviderService) {
        ConfigurationNode n = node.getNode(new Object[]{WARMUP});
        if (n instanceof CommentedConfigurationNode) {
            ((CommentedConfigurationNode)n).setComment(messageProviderService.getMessageString("config.warmup", new Object[0]));
        }
        n.setValue((Object)0);
    }

    @Override
    public void setDataFromNode(CommandModifiersConfig config, ConfigurationNode node) {
        config.setWarmup(node.getNode(new Object[]{WARMUP}).getInt(0));
    }

    @Override
    public void setValueFromOther(CommandModifiersConfig from, CommandModifiersConfig to) {
        to.setWarmup(from.getWarmup());
    }

    @Override
    public boolean canExecuteModifier(INucleusServiceCollection serviceCollection, CommandSource source) throws CommandException {
        return source instanceof Player;
    }

    @Override
    public Optional<ICommandResult> preExecute(final ICommandContext.Mutable<? extends CommandSource> source, final CommandControl control, final INucleusServiceCollection serviceCollection, CommandModifier modifier) {
        if (source.getWarmup() > 0) {
            final Player player = source.getCommandSourceAsPlayerUnchecked();
            serviceCollection.warmupService().cancel(player);
            serviceCollection.warmupService().executeAfter(player, Duration.ofSeconds(source.getWarmup()), new NucleusWarmupManagerService.WarmupTask(){

                @Override
                public void run() {
                    serviceCollection.messageProvider().sendMessageTo((CommandSource)player, "warmup.end");
                    control.startExecute(source);
                }

                @Override
                public void onCancel() {
                    control.onFail(source, null);
                }
            }, true);
            return Optional.of(ICommandResult.willContinueLater());
        }
        return Optional.empty();
    }
}

