/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.parameter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerOnlineService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;

public class DisplayNameArgument
extends CommandElement {
    private static boolean init = false;
    private static int USER_LIMIT = 20;
    private static boolean PARTIAL_MATCH = true;
    private final IPlayerOnlineService playerOnlineService;
    private final Target target;
    private final IPlayerDisplayNameService displayNameService;
    private final IMessageProviderService messageProviderService;

    public static void onReload(INucleusServiceCollection serviceCollection) {
        CoreConfig cc = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class);
        USER_LIMIT = Math.max(cc.getNicknameArgOfflineLimit(), 0);
        PARTIAL_MATCH = cc.isPartialMatch();
    }

    public DisplayNameArgument(@Nullable Text key, Target target, INucleusServiceCollection serviceCollection) {
        super(key);
        this.target = target;
        if (!init) {
            init = true;
            serviceCollection.reloadableService().registerReloadable(DisplayNameArgument::onReload);
        }
        this.displayNameService = serviceCollection.playerDisplayNameService();
        this.messageProviderService = serviceCollection.messageProvider();
        this.playerOnlineService = serviceCollection.playerOnlineService();
    }

    @Nullable
    public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String toParse = args.next();
        return this.parseValue(source, toParse, (key, entry) -> args.createError(this.messageProviderService.getMessageFor(source.getLocale(), (String)key, (String)entry)));
    }

    public Set<?> parseValue(CommandSource source, String toParse, BiFunction<String, String, ArgumentParseException> exceptionSupplier) throws ArgumentParseException {
        Optional user;
        Optional player;
        if (this.target == Target.PLAYER_CONSOLE && toParse.equalsIgnoreCase("-")) {
            return ImmutableSet.of((Object)Sponge.getServer().getConsole());
        }
        Predicate<Player> shouldShow = this.determinePredicate(source);
        boolean playerOnly = toParse.startsWith("p:");
        if (playerOnly) {
            toParse = toParse.substring(2);
        }
        if ((player = Sponge.getServer().getPlayer(toParse)).isPresent() && this.playerOnlineService.isOnline(source, (User)player.get())) {
            return ImmutableSet.of(player.get());
        }
        if (playerOnly) {
            throw exceptionSupplier.apply("args.user.nouser", toParse);
        }
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        if (!toParse.isEmpty() && this.target == Target.USER && (user = uss.get(toParse)).isPresent()) {
            return Collections.singleton(user.get());
        }
        Optional<Player> op = this.displayNameService.getPlayer(toParse.toLowerCase());
        if (op.map(u -> this.playerOnlineService.isOnline(source, (User)u)).isPresent()) {
            return Collections.singleton(op.get());
        }
        if (!PARTIAL_MATCH) {
            throw exceptionSupplier.apply("args.user.nouser", toParse);
        }
        if (toParse.length() < 3) {
            throw exceptionSupplier.apply("args.user.nouserfuzzy", toParse);
        }
        HashSet users = new HashSet();
        String parse = toParse.toLowerCase();
        this.displayNameService.startsWith(parse).keySet().stream().map(strings -> Sponge.getServer().getPlayer(strings).orElse(null)).filter(shouldShow).filter(Objects::nonNull).limit(USER_LIMIT).forEach(users::add);
        List uuids = users.stream().map(Identifiable::getUniqueId).collect(Collectors.toList());
        if (this.target == Target.USER) {
            if (PARTIAL_MATCH) {
                uss.match(parse).stream().map(x -> uss.get(x).orElse(null)).filter(Objects::nonNull).filter(x -> !uuids.contains(x.getUniqueId())).limit(USER_LIMIT).forEach(users::add);
            } else {
                uss.get(parse).filter(x -> !uuids.contains(x.getUniqueId())).ifPresent(users::add);
            }
        }
        if (users.isEmpty()) {
            throw exceptionSupplier.apply("args.user.nouser", toParse);
        }
        return new HashSet(users);
    }

    public List<String> complete(CommandSource source, CommandArgs args, CommandContext context) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            String toParse = args.peek();
            boolean playerOnly = toParse.startsWith("p:");
            if (playerOnly) {
                toParse = toParse.substring(2);
            }
            String parse = toParse.toLowerCase();
            Predicate<Player> shouldShow = this.determinePredicate(source);
            Predicate<Player> partial = x -> x.getName().toLowerCase().startsWith(parse);
            UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
            Sponge.getServer().getOnlinePlayers().stream().filter(partial.and(shouldShow)).forEach(player -> {
                if (playerOnly) {
                    names.add("p:" + player.getName());
                } else {
                    names.add(player.getName());
                }
            });
            if (!playerOnly) {
                this.displayNameService.startsWith(parse).entrySet().stream().map(x -> Sponge.getServer().getPlayer((UUID)x.getKey()).filter(shouldShow).map(y -> (List)x.getValue()).orElse((List)ImmutableList.of())).filter(Objects::nonNull).forEach(names::addAll);
                if (USER_LIMIT > 0 && this.target == Target.USER && !parse.isEmpty()) {
                    uss.match(parse).stream().map(x -> uss.get(x).map(User::getName).orElse(null)).filter(Objects::nonNull).limit(USER_LIMIT).forEach(names::add);
                }
            }
            return names;
        }
        catch (ArgumentParseException ex) {
            return names;
        }
    }

    private Predicate<Player> determinePredicate(CommandSource source) {
        return p -> this.playerOnlineService.isOnline(source, (User)p);
    }

    public static enum Target {
        PLAYER,
        PLAYER_CONSOLE,
        USER;

    }
}

