/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.permission;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.NucleusRequirePermissionArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.annotation.PermissionMetadata;
import io.github.nucleuspowered.nucleus.services.interfaces.data.SuggestedLevel;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import io.github.nucleuspowered.nucleus.util.PrettyPrinter;
import io.github.nucleuspowered.nucleus.util.ThrownFunction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.event.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.source.CommandBlockSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tristate;

@Singleton
public class NucleusPermissionService
implements IPermissionService,
IReloadableService.Reloadable,
ContextCalculator<Subject> {
    private final IMessageProviderService messageProviderService;
    private final INucleusServiceCollection serviceCollection;
    private boolean init = false;
    private boolean useRole = false;
    private boolean isOpOnly = true;
    private boolean consoleOverride = false;
    private final Set<ContextCalculator<Subject>> contextCalculators = new HashSet<ContextCalculator<Subject>>();
    private final Set<String> failedChecks = new HashSet<String>();
    private final Map<String, IPermissionService.Metadata> metadataMap = new HashMap<String, IPermissionService.Metadata>();
    private final Map<String, IPermissionService.Metadata> prefixMetadataMap = new HashMap<String, IPermissionService.Metadata>();
    private final Map<UUID, Map<String, Context>> standardContexts = new ConcurrentHashMap<UUID, Map<String, Context>>();
    private final Map<SuggestedLevel, Set<SubjectReference>> appliedRoles = new HashMap<SuggestedLevel, Set<SubjectReference>>();

    @Inject
    public NucleusPermissionService(INucleusServiceCollection serviceCollection, IReloadableService service) {
        this.messageProviderService = serviceCollection.messageProvider();
        this.serviceCollection = serviceCollection;
        Sponge.getServiceManager().provide(PermissionService.class).ifPresent(x -> x.registerContextCalculator((ContextCalculator)this));
        service.registerReloadable(this);
    }

    @Override
    public void assignUserRoleToDefault() {
        this.assignRoleToGroup(SuggestedLevel.USER, ((PermissionService)Sponge.getServiceManager().provideUnchecked(PermissionService.class)).getDefaults());
    }

    @Override
    public void assignRoleToGroup(SuggestedLevel role, Subject subject) {
        for (Map.Entry<String, IPermissionService.Metadata> permission : this.metadataMap.entrySet()) {
            if (permission.getValue().getSuggestedLevel() != role) continue;
            subject.getTransientSubjectData().setPermission((Set)ImmutableSet.of(), permission.getValue().getPermission(), Tristate.TRUE);
        }
        for (Map.Entry<String, IPermissionService.Metadata> permission : this.prefixMetadataMap.entrySet()) {
            if (permission.getValue().getSuggestedLevel() != role) continue;
            subject.getTransientSubjectData().setPermission((Set)ImmutableSet.of(), permission.getValue().getPermission(), Tristate.TRUE);
        }
    }

    @Override
    public boolean isOpOnly() {
        return this.isOpOnly;
    }

    @Override
    public void registerContextCalculator(ContextCalculator<Subject> calculator) {
        this.contextCalculators.add(calculator);
        Sponge.getServiceManager().provide(PermissionService.class).ifPresent(x -> x.registerContextCalculator(calculator));
    }

    @Override
    public void checkServiceChange(ProviderRegistration<PermissionService> service) {
        this.contextCalculators.forEach(x -> ((PermissionService)service.getProvider()).registerContextCalculator(x));
        ((PermissionService)service.getProvider()).registerContextCalculator((ContextCalculator)this);
        this.isOpOnly = service.getPlugin().getId().equals("sponge");
    }

    @Override
    public boolean hasPermission(Subject permissionSubject, String permission) {
        return this.hasPermission(permissionSubject, permission, this.useRole);
    }

    @Override
    public Tristate hasPermissionTristate(Subject subject, String permission) {
        return this.hasPermissionTristate(subject, permission, this.useRole);
    }

    @Override
    public boolean hasPermissionWithConsoleOverride(Subject subject, String permission, boolean permissionIfConsoleAndOverridden) {
        if (this.consoleOverride && subject instanceof ConsoleSource) {
            return permissionIfConsoleAndOverridden;
        }
        return this.hasPermission(subject, permission);
    }

    @Override
    public boolean isConsoleOverride(Subject subject) {
        return this.consoleOverride && subject instanceof ConsoleSource;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        CoreConfig coreConfig = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class);
        this.useRole = coreConfig.isUseParentPerms();
        this.consoleOverride = coreConfig.isConsoleOverride();
    }

    @Override
    public void registerDescriptions() {
        Preconditions.checkState((!this.init ? 1 : 0) != 0);
        this.init = true;
        PermissionService ps = Sponge.getServiceManager().provide(PermissionService.class).orElse(null);
        boolean isPresent = ps != null;
        for (Map.Entry<String, IPermissionService.Metadata> entry : this.metadataMap.entrySet()) {
            SuggestedLevel level = entry.getValue().getSuggestedLevel();
            if (!isPresent || level.getSpongeRole() == null) continue;
            ps.newDescriptionBuilder((Object)this.serviceCollection.pluginContainer()).assign(level.getSpongeRole(), true).description((Text)Text.of((String)entry.getValue().getDescription(this.messageProviderService))).id(entry.getKey()).register();
        }
    }

    @Override
    public void register(String permission, PermissionMetadata metadata, String moduleid) {
        Metadata m = new Metadata(permission, metadata, moduleid);
        if (metadata.isPrefix()) {
            this.prefixMetadataMap.put(permission.toLowerCase(), m);
        } else {
            this.metadataMap.put(permission.toLowerCase(), m);
        }
    }

    @Override
    public CommandElement createOtherUserPermissionElement(String permission) {
        return GenericArguments.optionalWeak((CommandElement)new NucleusRequirePermissionArgument(NucleusParameters.ONE_USER.get(this.serviceCollection), this, permission, false));
    }

    @Override
    public OptionalDouble getDoubleOptionFromSubject(Subject player, String ... options) {
        return this.getTypedObjectFromSubject(string -> OptionalDouble.of(Double.parseDouble(string)), OptionalDouble.empty(), player, options);
    }

    @Override
    public OptionalLong getPositiveLongOptionFromSubject(Subject player, String ... options) {
        return this.getTypedObjectFromSubject(string -> OptionalLong.of(Long.parseLong(string)), OptionalLong.empty(), player, options);
    }

    @Override
    public OptionalInt getPositiveIntOptionFromSubject(Subject player, String ... options) {
        return this.getTypedObjectFromSubject(string -> OptionalInt.of(Integer.parseUnsignedInt(string)), OptionalInt.empty(), player, options);
    }

    @Override
    public OptionalInt getIntOptionFromSubject(Subject player, String ... options) {
        return this.getTypedObjectFromSubject(string -> OptionalInt.of(Integer.parseInt(string)), OptionalInt.empty(), player, options);
    }

    private <T> T getTypedObjectFromSubject(ThrownFunction<String, T, Exception> conversion, T empty, Subject player, String ... options) {
        try {
            Optional<String> optional = this.getOptionFromSubject(player, options);
            if (optional.isPresent()) {
                return conversion.apply(optional.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return empty;
    }

    @Override
    public Optional<String> getOptionFromSubject(Subject player, String ... options) {
        for (String option : options) {
            String o = option.toLowerCase();
            Optional os = player.getOption(player.getActiveContexts(), o);
            if (os.isPresent()) {
                return os.map(r -> r.isEmpty() ? null : r);
            }
            os = player.getOption(o);
            if (!os.isPresent()) continue;
            return os.map(r -> r.isEmpty() ? null : r);
        }
        return Optional.empty();
    }

    @Override
    public PermissionMessageChannel permissionMessageChannel(String permission) {
        return new PermissionMessageChannel(this, permission);
    }

    @Override
    public List<IPermissionService.Metadata> getAllMetadata() {
        return ImmutableList.copyOf(this.metadataMap.values());
    }

    private boolean hasPermission(Subject subject, String permission, boolean checkRole) {
        Tristate tristate = this.hasPermissionTristate(subject, permission, checkRole);
        if (tristate == Tristate.UNDEFINED) {
            return subject.hasPermission(permission);
        }
        return tristate.asBoolean();
    }

    private Tristate hasPermissionTristate(Subject subject, String permission, boolean checkRole) {
        if (checkRole && permission.startsWith("nucleus.")) {
            Tristate tristate = subject.getPermissionValue(subject.getActiveContexts(), permission);
            if (tristate == Tristate.UNDEFINED) {
                IPermissionService.Metadata result = this.metadataMap.get(permission);
                if (result != null) {
                    String perm = result.getSuggestedLevel().getPermission();
                    if (perm == null) {
                        return subject.getPermissionValue(subject.getActiveContexts(), permission);
                    }
                    return subject.getPermissionValue(subject.getActiveContexts(), perm);
                }
                for (Map.Entry<String, IPermissionService.Metadata> entry : this.prefixMetadataMap.entrySet()) {
                    if (!permission.startsWith(entry.getKey())) continue;
                    String perm = entry.getValue().getSuggestedLevel().getPermission();
                    if (perm == null) {
                        return subject.getPermissionValue(subject.getActiveContexts(), permission);
                    }
                    return subject.getPermissionValue(subject.getActiveContexts(), perm);
                }
                if (this.failedChecks.add(permission)) {
                    PrettyPrinter printer = new PrettyPrinter(80);
                    printer.add("Nucleus Permission Not Registered").centre().hr();
                    printer.add("Nucleus has not registered a permission properly. This is an error in Nucleus - please report to the Nucleus github.");
                    printer.hr();
                    printer.add("Permission: %s", permission);
                    printer.log(this.serviceCollection.logger(), Level.WARN);
                }
                return Tristate.UNDEFINED;
            }
            return tristate;
        }
        return Tristate.UNDEFINED;
    }

    @Override
    public Optional<IPermissionService.Metadata> getMetadataFor(String permission) {
        return Optional.ofNullable(this.metadataMap.get(permission));
    }

    @Override
    public boolean isPermissionLevelOkay(Subject actor, Subject actee, String key, String permission, boolean isSameOkay) {
        int actorLevel = this.getDeclaredLevel(actor, key).orElseGet(() -> this.hasPermission(actor, permission) ? this.getDefaultLevel(actor) : 0);
        int acteeLevel = this.getDeclaredLevel(actee, key).orElseGet(() -> this.hasPermission(actee, permission) ? this.getDefaultLevel(actee) : 0);
        if (isSameOkay) {
            return actorLevel >= acteeLevel;
        }
        return actorLevel > acteeLevel;
    }

    @Override
    public void setContext(Subject subject, Context context) {
        if (subject instanceof Identifiable) {
            this.setContext(((Identifiable)subject).getUniqueId(), context);
        }
    }

    private void setContext(UUID uuid, Context context) {
        this.standardContexts.computeIfAbsent(uuid, k -> new HashMap()).put(context.getKey().toLowerCase(), context);
    }

    @Override
    public NoExceptionAutoClosable setContextTemporarily(Subject subject, Context context) {
        if (subject instanceof Identifiable) {
            UUID uuid = ((Identifiable)subject).getUniqueId();
            Context old = this.standardContexts.computeIfAbsent(uuid, k -> new HashMap()).put(context.getKey().toLowerCase(), context);
            return () -> {
                this.removeContext(uuid, context.getKey().toLowerCase());
                if (old != null) {
                    this.setContext(uuid, context);
                }
            };
        }
        return NoExceptionAutoClosable.EMPTY;
    }

    @Override
    public void removeContext(UUID subject, String key) {
        Map<String, Context> contexts = this.standardContexts.get(subject);
        if (contexts != null && !contexts.isEmpty()) {
            contexts.remove(key.toLowerCase());
        }
    }

    @Override
    public void removePlayerContexts(UUID uuid) {
        this.standardContexts.remove(uuid);
    }

    public void accumulateContexts(Subject target, Set<Context> accumulator) {
        Map<String, Context> ctxs;
        if (target instanceof Identifiable && (ctxs = this.standardContexts.get(((Identifiable)target).getUniqueId())) != null && !ctxs.isEmpty()) {
            accumulator.addAll(ctxs.values());
        }
    }

    public boolean matches(Context context, Subject target) {
        Map<String, Context> ctxs;
        if (target instanceof Identifiable && (ctxs = this.standardContexts.get(((Identifiable)target).getUniqueId())) != null && !ctxs.isEmpty()) {
            Context ctx = ctxs.get(context.getKey());
            return ctx.equals((Object)context);
        }
        return false;
    }

    private int getDefaultLevel(Subject subject) {
        if (subject instanceof ConsoleSource || subject instanceof CommandBlockSource) {
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    public static class Metadata
    implements IPermissionService.Metadata {
        private final String description;
        private final String permission;
        private final SuggestedLevel suggestedLevel;
        private final boolean isPrefix;
        private final String[] replacements;
        private final String moduleid;

        Metadata(String permission, PermissionMetadata metadata, String moduleid) {
            this(metadata.descriptionKey(), metadata.replacements(), permission, metadata.level(), metadata.isPrefix(), moduleid);
        }

        Metadata(String description, String[] replacements, String permission, SuggestedLevel suggestedLevel, boolean isPrefix, String moduleid) {
            this.description = description;
            this.replacements = replacements;
            this.permission = permission.toLowerCase();
            this.suggestedLevel = suggestedLevel;
            this.isPrefix = isPrefix;
            this.moduleid = moduleid;
        }

        @Override
        public boolean isPrefix() {
            return this.isPrefix;
        }

        @Override
        public SuggestedLevel getSuggestedLevel() {
            return this.suggestedLevel;
        }

        @Override
        public String getDescription(IMessageProviderService service) {
            return service.getMessageString(this.description, this.replacements);
        }

        @Override
        public String getPermission() {
            return this.permission;
        }

        @Override
        public String getModuleId() {
            return this.moduleid;
        }
    }
}

