/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.playername;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatTemplateConfig;
import io.github.nucleuspowered.nucleus.modules.chat.services.ChatService;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

@Singleton
public class PlayerDisplayNameService
implements IPlayerDisplayNameService,
IReloadableService.Reloadable {
    private final LinkedHashSet<IPlayerDisplayNameService.DisplayNameResolver> resolvers = new LinkedHashSet();
    private final LinkedHashSet<IPlayerDisplayNameService.DisplayNameQuery> queries = new LinkedHashSet();
    private final IMessageProviderService messageProviderService;
    private final IPermissionService permissionService;
    private final INucleusServiceCollection serviceCollection;
    private final ITextStyleService textStyleService;
    private String commandNameOnClick = null;

    @Inject
    public PlayerDisplayNameService(INucleusServiceCollection serviceCollection) {
        this.messageProviderService = serviceCollection.messageProvider();
        this.permissionService = serviceCollection.permissionService();
        this.textStyleService = serviceCollection.textStyleService();
        this.serviceCollection = serviceCollection;
        serviceCollection.reloadableService().registerReloadable(this);
    }

    @Override
    public void provideDisplayNameResolver(IPlayerDisplayNameService.DisplayNameResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public void provideDisplayNameQuery(IPlayerDisplayNameService.DisplayNameQuery resolver) {
        this.queries.add(resolver);
    }

    @Override
    public Optional<User> getUser(String displayName) {
        Optional withRealName = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(displayName);
        if (withRealName.isPresent()) {
            return withRealName;
        }
        for (IPlayerDisplayNameService.DisplayNameQuery query : this.queries) {
            Optional<User> user = query.resolve(displayName);
            if (!user.isPresent()) continue;
            return user;
        }
        return Optional.empty();
    }

    @Override
    public Optional<Player> getPlayer(String displayName) {
        Optional withRealName = Sponge.getServer().getPlayer(displayName);
        if (withRealName.isPresent()) {
            return withRealName;
        }
        for (IPlayerDisplayNameService.DisplayNameQuery query : this.queries) {
            Optional<User> user = query.resolve(displayName);
            if (!user.isPresent() || !user.get().getPlayer().isPresent()) continue;
            return user.get().getPlayer();
        }
        return Optional.empty();
    }

    @Override
    public Map<UUID, List<String>> startsWith(String displayName) {
        HashMap<UUID, List<String>> uuids = new HashMap<UUID, List<String>>();
        Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(displayName.toLowerCase())).forEach(x -> {
            List cfr_ignored_0 = uuids.put(x.getUniqueId(), Lists.newArrayList((Object[])new String[]{x.getName()}));
        });
        for (IPlayerDisplayNameService.DisplayNameQuery query : this.queries) {
            query.startsWith(displayName).forEach((uuid, name) -> uuids.computeIfAbsent((UUID)uuid, x -> new ArrayList()).add(name));
        }
        return uuids;
    }

    @Override
    public Optional<User> getUser(Text displayName) {
        return this.getUser(displayName.toPlain());
    }

    @Override
    public Optional<Player> getPlayer(Text displayName) {
        return this.getPlayer(displayName.toPlain());
    }

    @Override
    public Text getDisplayName(UUID playerUUID) {
        if (playerUUID.equals(Util.CONSOLE_FAKE_UUID)) {
            return this.getName((CommandSource)Sponge.getServer().getConsole());
        }
        User user = (User)((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(playerUUID).orElseThrow(() -> new IllegalArgumentException("UUID does not map to a player"));
        Text userName = null;
        for (IPlayerDisplayNameService.DisplayNameResolver resolver : this.resolvers) {
            Optional<Text> optionalUserName = resolver.resolve(playerUUID);
            if (!optionalUserName.isPresent()) continue;
            userName = optionalUserName.get();
            break;
        }
        Object builder = userName == null ? Text.builder((String)user.getName()) : Text.builder().append(new Text[]{userName});
        this.addCommandToNameInternal((Text.Builder)builder, user);
        this.applyStyle((Subject)user, (Text.Builder)builder);
        return builder.build();
    }

    @Override
    public Text getDisplayName(CommandSource source) {
        if (source instanceof User) {
            return this.getDisplayName(((User)source).getUniqueId());
        }
        return this.getName(source);
    }

    @Override
    public Text getName(CommandSource user) {
        LiteralText.Builder builder = Text.builder((String)user.getName());
        this.applyStyle((Subject)user, (Text.Builder)builder);
        if (user instanceof User) {
            this.addCommandToNameInternal((Text.Builder)builder, (User)user);
        }
        return builder.build();
    }

    private void applyStyle(Subject subject, Text.Builder builder) {
        TextStyle[] textStyleArray = new TextStyle[1];
        textStyleArray[0] = this.getStyle(subject, this.textStyleService::getTextStyleFromString, ChatTemplateConfig::getChatstyle, TextStyles.NONE, "namestyle");
        builder.color(this.getStyle(subject, this.textStyleService::getColourFromString, ChatTemplateConfig::getChatcolour, (TextElement)TextColors.NONE, "namecolour", "namecolor")).style(textStyleArray);
    }

    @Override
    public Text addCommandToName(CommandSource p) {
        LiteralText.Builder text = Text.builder((String)p.getName());
        if (p instanceof User) {
            this.addCommandToNameInternal((Text.Builder)text, (User)p);
        }
        return text.build();
    }

    @Override
    public Text addCommandToDisplayName(CommandSource p) {
        Text.Builder name = this.getName(p).toBuilder();
        if (p instanceof User) {
            this.addCommandToNameInternal(name, (User)p);
        }
        return name.build();
    }

    private void addCommandToNameInternal(Text.Builder name, User user) {
        if (this.commandNameOnClick == null) {
            name.onHover((HoverAction)TextActions.showText((Text)this.messageProviderService.getMessage("name.hover.ign", user.getName()))).build();
            return;
        }
        String commandToRun = this.commandNameOnClick.replace("{{subject}}", user.getName()).replace("{{player}}", user.getName());
        Text.Builder hoverAction = Text.builder().append(new Text[]{this.messageProviderService.getMessage("name.hover.ign", user.getName())}).append(new Text[]{Text.NEW_LINE}).append(new Text[]{this.messageProviderService.getMessage("name.hover.command", commandToRun)});
        name.onClick((ClickAction)TextActions.suggestCommand((String)commandToRun)).onHover((HoverAction)TextActions.showText((Text)hoverAction.toText())).build();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.commandNameOnClick = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).getCommandOnNameClick();
        if (this.commandNameOnClick == null || this.commandNameOnClick.isEmpty()) {
            return;
        }
        if (!this.commandNameOnClick.startsWith("/")) {
            this.commandNameOnClick = "/" + this.commandNameOnClick;
        }
        if (!this.commandNameOnClick.endsWith(" ")) {
            this.commandNameOnClick = this.commandNameOnClick + " ";
        }
    }

    private <T extends TextElement> T getStyle(Subject player, Function<String, T> returnIfAvailable, Function<ChatTemplateConfig, String> fromTemplate, T def, String ... options) {
        Optional<String> os = this.permissionService.getOptionFromSubject(player, options);
        if (os.isPresent()) {
            return (T)((TextElement)returnIfAvailable.apply(os.get()));
        }
        return (T)this.serviceCollection.getService(ChatService.class).map(templateUtil -> (TextElement)returnIfAvailable.apply((String)fromTemplate.apply(templateUtil.getTemplateNow(player)))).orElse(def);
    }
}

