/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.userprefs;

import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.api.core.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.PreferenceKeyImpl;
import io.github.nucleuspowered.nucleus.services.interfaces.IModuleDataProvider;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.service.permission.Subject;

public class NucleusKeysProvider
implements NucleusUserPreferenceService.Keys {
    private final IModuleDataProvider moduleDataProvider;
    public static final String COMMAND_SPY_KEY = "nucleus:command-spy";
    public static final String MESSAGE_TOGGLE_KEY = "nucleus:message-receiving-enabled";
    public static final String PLAYER_LOCALE_KEY = "nucleus:player-locale";
    public static final String POWERTOOL_ENABLED_KEY = "nucleus:powertool-toggle";
    public static final String SOCIAL_SPY_KEY = "nucleus:social-spy";
    public static final String TELEPORT_TARGETABLE_KEY = "nucleus:teleport-targetable";
    public static final String VANISH_ON_LOGIN_KEY = "nucleus:vanish-on-login";
    public static final String VIEW_STAFF_CHAT_KEY = "nucleus:view-staff-chat";
    public static final PreferenceKeyImpl<Boolean> COMMAND_SPY = new PreferenceKeyImpl.BooleanKey("nucleus:command-spy", (Boolean)true, "nucleus.commandspy.base", "userpref.commandspy", "command-spy");
    public static final PreferenceKeyImpl<Boolean> RECEIVING_MESSAGES = new PreferenceKeyImpl.BooleanKey("nucleus:message-receiving-enabled", (Boolean)true, "nucleus.msgtoggle.bypass", "userpref.messagetoggle", "message");
    public static final PreferenceKeyImpl<Boolean> POWERTOOL_ENABLED = new PreferenceKeyImpl.BooleanKey("nucleus:powertool-toggle", (Boolean)true, "nucleus.powertool.base", "userpref.powertooltoggle", "powertool");
    public static final PreferenceKeyImpl<Boolean> TELEPORT_TARGETABLE = new PreferenceKeyImpl.BooleanKey("nucleus:teleport-targetable", (Boolean)true, "nucleus.teleport.tptoggle.base", "userpref.teleporttarget", "teleport");
    public static final PreferenceKeyImpl<Boolean> VANISH_ON_LOGIN = new PreferenceKeyImpl.BooleanKey("nucleus:vanish-on-login", (Boolean)false, "nucleus.vanish.onlogin", "userpref.vanishonlogin", "vanish");
    public static final PreferenceKeyImpl<Boolean> VIEW_STAFF_CHAT = new PreferenceKeyImpl.BooleanKey("nucleus:view-staff-chat", (Boolean)true, "nucleus.staffchat.base", "userpref.viewstaffchat", "staff-chat");
    public static final PreferenceKeyImpl<Boolean> SOCIAL_SPY = new PreferenceKeyImpl.BooleanKey("nucleus:social-spy", (Boolean)true, (serviceCollection, user) -> serviceCollection.permissionService().hasPermission((Subject)user, "nucleus.socialspy.base") && !serviceCollection.permissionService().hasPermission((Subject)user, "nucleus.socialspy.force"), "userpref.socialspy", "message");
    public static final PreferenceKeyImpl<Locale> PLAYER_LOCALE = new PreferenceKeyImpl.LocaleKey("nucleus:player-locale", Locale.UK, "nucleus.nucleuslanguage.base", "userpref.player_locale", "core", (serviceCollection, uuid, value) -> serviceCollection.messageProvider().invalidateLocaleCacheFor((UUID)uuid));

    public NucleusKeysProvider(INucleusServiceCollection serviceCollection) {
        this.moduleDataProvider = serviceCollection.moduleDataProvider();
    }

    public Collection<NucleusUserPreferenceService.PreferenceKey<?>> getAll() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.vanishOnLogin().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.teleportTarget().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.powertoolsEnabled().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.socialSpyEnabled().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.messageReceivingEnabled().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.commandSpyEnabled().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.viewStaffChat().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.playerLocale().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> vanishOnLogin() {
        return VANISH_ON_LOGIN.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> teleportTarget() {
        return TELEPORT_TARGETABLE.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> powertoolsEnabled() {
        return POWERTOOL_ENABLED.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> socialSpyEnabled() {
        return SOCIAL_SPY.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> messageReceivingEnabled() {
        return RECEIVING_MESSAGES.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> commandSpyEnabled() {
        return COMMAND_SPY.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Boolean>> viewStaffChat() {
        return VIEW_STAFF_CHAT.getIfLoaded(this.moduleDataProvider);
    }

    @Override
    public Optional<NucleusUserPreferenceService.PreferenceKey<Locale>> playerLocale() {
        return Optional.of(PLAYER_LOCALE);
    }
}

