/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.nucleus.neutrino.objectmapper;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.nucleuspowered.relocate.nucleus.neutrino.objectmapper.NeutrinoObjectMapper;
import io.github.nucleuspowered.relocate.nucleus.neutrino.settingprocessor.SettingProcessor;
import io.github.nucleuspowered.relocate.nucleus.neutrino.util.ClassConstructor;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;

public class NeutrinoObjectMapperFactory
implements ObjectMapperFactory {
    private static NeutrinoObjectMapperFactory INSTANCE;
    private final ClassConstructor<SettingProcessor> processorClassConstructor;
    private final Function<Setting, String> commentProcessor;
    private final LoadingCache<Class<?>, NeutrinoObjectMapper<?>> mapperCache = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).build(new CacheLoader<Class<?>, NeutrinoObjectMapper<?>>(){

        public NeutrinoObjectMapper<?> load(@Nonnull Class<?> key) throws Exception {
            return new NeutrinoObjectMapper(key, NeutrinoObjectMapperFactory.this.commentProcessor, NeutrinoObjectMapperFactory.this.processorClassConstructor);
        }
    });

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static ObjectMapperFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NeutrinoObjectMapperFactory(false, Setting::comment, Class::newInstance);
        }
        return INSTANCE;
    }

    private NeutrinoObjectMapperFactory(boolean setInstance, Function<Setting, String> commentProcessor, ClassConstructor<SettingProcessor> processorClassConstructor) {
        this.commentProcessor = commentProcessor;
        this.processorClassConstructor = processorClassConstructor;
        if (INSTANCE == null || setInstance) {
            INSTANCE = this;
        }
    }

    public <T> NeutrinoObjectMapper<T> getMapper(Class<T> type) throws ObjectMappingException {
        Preconditions.checkNotNull(type, (Object)"type");
        try {
            return (NeutrinoObjectMapper)((Object)this.mapperCache.get(type));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new ObjectMappingException((Throwable)e);
        }
    }

    public static class Builder {
        @Nullable
        private Function<Setting, String> commentProcessor;
        private ClassConstructor<SettingProcessor> settingProcessorClassConstructor = Class::newInstance;

        public Builder setCommentProcessor(@Nullable Function<Setting, String> commentProcessor) {
            this.commentProcessor = commentProcessor;
            return this;
        }

        public Builder setSettingProcessorClassConstructor(ClassConstructor<SettingProcessor> settingProcessorClassConstructor) {
            this.settingProcessorClassConstructor = (ClassConstructor)Preconditions.checkNotNull(settingProcessorClassConstructor);
            return this;
        }

        public NeutrinoObjectMapperFactory build(boolean setAsDefault) {
            if (this.commentProcessor == null) {
                this.commentProcessor = Setting::comment;
            }
            return new NeutrinoObjectMapperFactory(setAsDefault, this.commentProcessor, this.settingProcessorClassConstructor);
        }
    }
}

