/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.holders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleHolder;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleMetadata;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.holders.discoverystrategies.Strategy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.ModuleConstructor;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.SimpleModuleConstructor;
import java.util.Set;
import java.util.stream.Collectors;

public final class DiscoveryModuleHolder<M extends Module, D extends M>
extends ModuleHolder<M, D> {
    private final ClassLoader classLoader;
    private final ModuleConstructor<M> constructor;
    private final String packageLocation;
    private final Set<Class<?>> loadedClasses = Sets.newHashSet();
    private final Strategy strategy;

    public static <M extends Module, D extends M> Builder<M, D> builder(Class<M> moduleClass, Class<D> disableClass) {
        return new Builder<M, D>(moduleClass, disableClass);
    }

    private DiscoveryModuleHolder(Builder<M, D> builder) throws QuickStartModuleDiscoveryException {
        super(builder);
        this.classLoader = ((Builder)builder).classLoader;
        this.constructor = ((Builder)builder).constructor;
        this.packageLocation = ((Builder)builder).packageToScan;
        this.strategy = ((Builder)builder).strategy;
    }

    @Override
    protected Set<Class<? extends M>> discoverModules() throws Exception {
        this.loadedClasses.addAll(this.strategy.discover(this.packageLocation, this.classLoader));
        Class basicClass = this.getBaseClass();
        Set<Class<M>> modules = this.loadedClasses.stream().filter(basicClass::isAssignableFrom).map(x -> x.asSubclass(basicClass)).collect(Collectors.toSet());
        if (modules.isEmpty()) {
            throw new QuickStartModuleDiscoveryException("No modules were found", null);
        }
        return modules;
    }

    @Override
    protected M constructModule(ModuleMetadata<? extends M> spec) throws Exception {
        return this.constructor.constructModule(spec.getModuleClass());
    }

    public final Set<Class<?>> getLoadedClasses() {
        return ImmutableSet.copyOf(this.loadedClasses);
    }

    public static final class Builder<M extends Module, D extends M>
    extends ModuleHolder.Builder<M, D, DiscoveryModuleHolder<M, D>, Builder<M, D>> {
        private String packageToScan;
        private ModuleConstructor<M> constructor = new SimpleModuleConstructor<M>();
        private ClassLoader classLoader;
        private Strategy strategy = Strategy.DEFAULT;

        Builder(Class<M> moduleType, Class<D> disableType) {
            super(moduleType, disableType);
        }

        public Builder<M, D> setPackageToScan(String packageToScan) {
            this.packageToScan = packageToScan;
            return this;
        }

        public Builder<M, D> setConstructor(ModuleConstructor<M> constructor) {
            this.constructor = constructor;
            return this;
        }

        public Builder<M, D> setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder<M, D> setStrategy(Strategy strategy) {
            this.strategy = (Strategy)Preconditions.checkNotNull((Object)strategy);
            return this;
        }

        @Override
        protected Builder<M, D> getThis() {
            return this;
        }

        @Override
        public DiscoveryModuleHolder<M, D> build() throws QuickStartModuleDiscoveryException {
            Preconditions.checkNotNull((Object)this.packageToScan);
            if (this.constructor == null) {
                this.constructor = new SimpleModuleConstructor<M>();
            }
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            this.checkBuild();
            return new DiscoveryModuleHolder(this);
        }
    }
}

