/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleHolder;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.ModuleEnablerBuilder;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.util.ThrownBiConsumer;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.util.ThrownConsumer;
import java.util.Set;

public class PhasedModuleEnabler<M extends Module, D extends M> {
    private final ImmutableMap<String, ThrownBiConsumer<D, ModuleHolder<M, D>, Exception>> disablePhases;
    private final ImmutableMap<String, ThrownConsumer<ModuleHolder<M, D>, Exception>> enablePrePhases;
    private final ImmutableMap<String, ThrownBiConsumer<M, ModuleHolder<M, D>, Exception>> enablePhases;
    private final ImmutableSet<String> phases;
    private final ImmutableSet<String> dPhases;

    PhasedModuleEnabler(ModuleEnablerBuilder<M, D> builder) {
        this.disablePhases = ImmutableMap.copyOf(builder.disablePhase);
        this.enablePhases = ImmutableMap.copyOf(builder.enablePhases);
        this.enablePrePhases = ImmutableMap.copyOf(builder.enablePrePhases);
        this.phases = ImmutableSet.copyOf(builder.phases);
        this.dPhases = ImmutableSet.copyOf(builder.dPhases);
    }

    public Set<String> getEnablePhases() {
        return this.phases;
    }

    public Set<String> getDisablePhases() {
        return this.dPhases;
    }

    public final void startEnablePrePhase(String phase, ModuleHolder<M, D> moduleHolder) throws Exception {
        String lcPhase = phase.toLowerCase();
        ThrownConsumer ta = (ThrownConsumer)this.enablePrePhases.get((Object)lcPhase);
        if (ta != null) {
            ta.apply(moduleHolder);
        }
    }

    public final void startEnablePhase(String phase, ModuleHolder<M, D> moduleHolder, M module) throws Exception {
        String lcPhase = phase.toLowerCase();
        ThrownBiConsumer tc = (ThrownBiConsumer)this.enablePhases.get((Object)lcPhase);
        if (tc != null) {
            tc.apply(module, moduleHolder);
        }
    }

    public final void startDisablePhase(String phase, ModuleHolder<M, D> moduleHolder, D module) throws Exception {
        String lcPhase = phase.toLowerCase();
        ThrownBiConsumer tc = (ThrownBiConsumer)this.disablePhases.get((Object)lcPhase);
        if (tc != null) {
            tc.apply(module, moduleHolder);
        }
    }
}

